/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data;

import java.util.HashMap;
import java.util.Map;
import net.gegy1000.justnow.executor.CurrentThreadExecutor;
import net.gegy1000.justnow.executor.LocalExecutor;
import net.gegy1000.justnow.executor.TaskHandle;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.DataGenerator;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.minecraft.util.math.ChunkPos;

public final class ColumnDataLoader
implements AutoCloseable {
    private final DataGenerator generator;
    private final Map<ChunkPos, TaskHandle<ColumnData>> taskMap = new HashMap<ChunkPos, TaskHandle<ColumnData>>();
    private final LocalExecutor executor = new LocalExecutor();

    ColumnDataLoader(DataGenerator generator) {
        this.generator = generator;
    }

    public void advanceUntil(long endNanoTime) {
        while (System.nanoTime() < endNanoTime && this.executor.advanceAll()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ColumnData> spawn(ChunkPos columnPos) {
        TaskHandle<ColumnData> handle = this.executor.spawn(this.generate(columnPos));
        Map<ChunkPos, TaskHandle<ColumnData>> map = this.taskMap;
        synchronized (map) {
            this.taskMap.put(columnPos, handle);
        }
        return handle;
    }

    public ColumnData getNow(ChunkPos columnPos) {
        Future<ColumnData> future = this.stealTask(columnPos);
        if (future == null) {
            future = this.generate(columnPos);
        }
        return CurrentThreadExecutor.blockOn(future);
    }

    private Future<ColumnData> generate(ChunkPos columnPos) {
        return this.generator.generate(DataView.of(columnPos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<ColumnData> stealTask(ChunkPos columnPos) {
        TaskHandle<ColumnData> task;
        Map<ChunkPos, TaskHandle<ColumnData>> map = this.taskMap;
        synchronized (map) {
            task = this.taskMap.remove(columnPos);
        }
        return task != null ? this.executor.steal(task) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ChunkPos columnPos) {
        Map<ChunkPos, TaskHandle<ColumnData>> map = this.taskMap;
        synchronized (map) {
            TaskHandle<ColumnData> handle = this.taskMap.remove(columnPos);
            if (handle != null) {
                this.executor.cancel(handle);
            }
        }
    }

    @Override
    public void close() {
        this.cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAll() {
        Map<ChunkPos, TaskHandle<ColumnData>> map = this.taskMap;
        synchronized (map) {
            for (TaskHandle<ColumnData> handle : this.taskMap.values()) {
                this.executor.cancel(handle);
            }
            this.taskMap.clear();
        }
    }
}

