/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.op;

import java.util.Optional;
import java.util.function.Function;
import net.gegy1000.terrarium.server.util.Vec2i;
import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.ByteRaster;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.ObjRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.gegy1000.terrarium.server.world.data.source.DataSourceReader;
import net.gegy1000.terrarium.server.world.data.source.DataTileResult;
import net.gegy1000.terrarium.server.world.data.source.TiledDataSource;
import net.minecraft.util.math.MathHelper;

public final class SampleRaster {
    public static DataOp<ShortRaster> sampleShort(TiledDataSource<ShortRaster> source) {
        return SampleRaster.sample(source, ShortRaster::create);
    }

    public static DataOp<ByteRaster> sampleByte(TiledDataSource<ByteRaster> source) {
        return SampleRaster.sample(source, ByteRaster::create);
    }

    public static DataOp<UByteRaster> sampleUByte(TiledDataSource<UByteRaster> source) {
        return SampleRaster.sample(source, UByteRaster::create);
    }

    public static <T> DataOp<ObjRaster<T>> sampleObj(TiledDataSource<ObjRaster<T>> source, T defaultValue) {
        return SampleRaster.sample(source, view -> ObjRaster.create(defaultValue, view));
    }

    public static <T extends Enum<T>> DataOp<EnumRaster<T>> sampleEnum(TiledDataSource<EnumRaster<T>> source, T defaultValue) {
        return SampleRaster.sample(source, view -> EnumRaster.create(defaultValue, view));
    }

    public static <T extends Raster<?>> DataOp<T> sample(TiledDataSource<T> source, Function<DataView, T> function) {
        return DataOp.of((view, ctx) -> {
            int tileWidth = MathHelper.func_76128_c((double)source.getTileWidth());
            int tileHeight = MathHelper.func_76128_c((double)source.getTileHeight());
            return DataSourceReader.INSTANCE.getTiles(source, view).map(tiles -> {
                for (DataTileResult tileResult : tiles) {
                    if (tileResult.data.isPresent()) continue;
                    return Optional.empty();
                }
                Raster resultRaster = (Raster)function.apply(view);
                for (DataTileResult tileResult : tiles) {
                    Raster sourceRaster = (Raster)tileResult.data.get();
                    Vec2i tilePos = tileResult.pos;
                    DataView sourceView = DataView.rect(tilePos.x * tileWidth, tilePos.y * tileHeight, tileWidth, tileHeight);
                    Raster.rasterCopy(sourceRaster, sourceView, resultRaster, view);
                }
                return Optional.of(resultRaster);
            });
        });
    }
}

