/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import java.util.Arrays;
import java.util.Optional;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.AbstractRaster;
import net.gegy1000.terrarium.server.world.data.raster.NumberRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;

public final class FloatRaster
extends AbstractRaster<float[]>
implements NumberRaster<float[]> {
    private FloatRaster(float[] data, int width, int height) {
        super(data, width, height);
    }

    public static FloatRaster create(int width, int height) {
        float[] array = new float[width * height];
        return new FloatRaster(array, width, height);
    }

    public static FloatRaster create(DataView view) {
        return FloatRaster.create(view.getWidth(), view.getHeight());
    }

    public static FloatRaster create(DataView view, float value) {
        FloatRaster raster = FloatRaster.create(view.getWidth(), view.getHeight());
        Arrays.fill((float[])raster.data, value);
        return raster;
    }

    public static Sampler sampler(DataKey<FloatRaster> key) {
        return new Sampler(key);
    }

    public void set(int x, int y, float value) {
        ((float[])this.data)[this.index((int)x, (int)y)] = value;
    }

    public float get(int x, int y) {
        return ((float[])this.data)[this.index(x, y)];
    }

    public void transform(Transformer transformer) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = this.index(x, y);
                ((float[])this.data)[index] = transformer.apply(((float[])this.data)[index], x, y);
            }
        }
    }

    public void iterate(Iterator iterator) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                iterator.accept(((float[])this.data)[this.index(x, y)], x, y);
            }
        }
    }

    @Override
    public void setFloat(int x, int y, float value) {
        this.set(x, y, value);
    }

    @Override
    public float getFloat(int x, int y) {
        return this.get(x, y);
    }

    public FloatRaster copy() {
        return new FloatRaster(Arrays.copyOf((float[])this.data, ((float[])this.data).length), this.width, this.height);
    }

    public static class Sampler
    implements Raster.Sampler<FloatRaster> {
        private final DataKey<FloatRaster> key;
        private float defaultValue;

        Sampler(DataKey<FloatRaster> key) {
            this.key = key;
        }

        public Sampler defaultValue(float value) {
            this.defaultValue = value;
            return this;
        }

        public float sample(ColumnDataCache dataCache, int x, int z) {
            ColumnData data = dataCache.joinData(x >> 4, z >> 4);
            return this.sample(data, x & 0xF, z & 0xF);
        }

        public float sample(ColumnData data, int x, int z) {
            Optional<FloatRaster> optional = data.get(this.key);
            if (optional.isPresent()) {
                FloatRaster raster = optional.get();
                return raster.get(x, z);
            }
            return this.defaultValue;
        }

        @Override
        public FloatRaster sample(ColumnDataCache dataCache, DataView view) {
            FloatRaster raster = FloatRaster.create(view);
            if (this.defaultValue != 0.0f) {
                Arrays.fill((float[])raster.data, this.defaultValue);
            }
            AbstractRaster.sampleInto(raster, dataCache, view, this.key);
            return raster;
        }
    }

    public static interface Iterator {
        public void accept(float var1, int var2, int var3);
    }

    public static interface Transformer {
        public float apply(float var1, int var2, int var3);
    }
}

