/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.generator.customization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import net.gegy1000.terrarium.server.world.generator.customization.widget.CustomizationCategory;
import net.gegy1000.terrarium.server.world.generator.customization.widget.CustomizationWidget;

public class TerrariumCustomization {
    public static final TerrariumCustomization EMPTY = new TerrariumCustomization(Collections.emptyList());
    private final Collection<CustomizationCategory> categories;

    public TerrariumCustomization(Collection<CustomizationCategory> categories) {
        this.categories = categories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<CustomizationCategory> getCategories() {
        return this.categories;
    }

    public static class Builder {
        private final ImmutableList.Builder<CustomizationCategory> categories = new ImmutableList.Builder();

        private Builder() {
        }

        public Builder withCategory(String identifier, CustomizationWidget ... widgets) {
            this.categories.add((Object)new CustomizationCategory(identifier, Lists.newArrayList((Object[])widgets)));
            return this;
        }

        public TerrariumCustomization build() {
            return new TerrariumCustomization((Collection<CustomizationCategory>)this.categories.build());
        }
    }
}

