/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.IntegrationHelper;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockLookTrigger;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.BlockForgedCrate;
import se.mickelus.tetra.blocks.forged.BlockForgedPillar;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatform;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatformSlab;
import se.mickelus.tetra.blocks.forged.BlockForgedVent;
import se.mickelus.tetra.blocks.forged.BlockForgedWall;
import se.mickelus.tetra.blocks.forged.ForgedWorkbenchBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTESR;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPipeBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonTile;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitTile;
import se.mickelus.tetra.blocks.geode.GeodeBlock;
import se.mickelus.tetra.blocks.geode.GeodeItem;
import se.mickelus.tetra.blocks.geode.PristineDiamondItem;
import se.mickelus.tetra.blocks.geode.PristineEmeraldItem;
import se.mickelus.tetra.blocks.geode.PristineLapisItem;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.data.UpdateDataPacket;
import se.mickelus.tetra.data.provider.ModuleProvider;
import se.mickelus.tetra.effects.BleedingEffect;
import se.mickelus.tetra.effects.EarthboundEffect;
import se.mickelus.tetra.effects.StunEffect;
import se.mickelus.tetra.generation.FeatureEntry;
import se.mickelus.tetra.generation.TGenCommand;
import se.mickelus.tetra.items.ITetraItem;
import se.mickelus.tetra.items.JournalItem;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.ItemBeam;
import se.mickelus.tetra.items.forged.ItemBolt;
import se.mickelus.tetra.items.forged.ItemMesh;
import se.mickelus.tetra.items.forged.ItemMetalScrap;
import se.mickelus.tetra.items.forged.ItemQuickLatch;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.items.forged.VibrationDebuffer;
import se.mickelus.tetra.items.modular.BasicMajorModule;
import se.mickelus.tetra.items.modular.BasicModule;
import se.mickelus.tetra.items.modular.ItemPredicateModular;
import se.mickelus.tetra.items.modular.SecondaryAbilityPacket;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltModule;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.module.DisenchantmentHandler;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.ModuleDevCommand;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.MultiSlotModule;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.module.schema.BookEnchantSchema;
import se.mickelus.tetra.module.schema.CleanseSchema;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.proxy.ClientProxy;
import se.mickelus.tetra.proxy.IProxy;
import se.mickelus.tetra.proxy.ServerProxy;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="tetra")
public class TetraMod {
    private static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "tetra";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static TetraMod instance;
    private static Item[] items;
    private static Block[] blocks;

    public TetraMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IntegrationHelper::enqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEffectHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DisenchantmentHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DataManager());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)BlockLookTrigger.instance);
        MinecraftForge.EVENT_BUS.register((Object)new VibrationDebuffer());
        ConfigHandler.setup();
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new FortuneBonusCondition.Serializer());
        new RepairRegistry();
        SchemaRegistry schemaRegistry = new SchemaRegistry();
        schemaRegistry.registerSchema(new BookEnchantSchema());
        new ItemUpgradeRegistry();
        ModuleRegistry moduleRegistry = new ModuleRegistry();
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_module"), BasicModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_major_module"), BasicMajorModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "multi_major_module"), MultiSlotModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "toolbelt_module"), ToolbeltModule::new);
        new TetraItemGroup();
        CriteriaTriggers.func_192118_a((ICriterionTrigger)BlockLookTrigger.instance);
        CriteriaTriggers.func_192118_a(BlockUseCriterion.trigger);
        CriteriaTriggers.func_192118_a(BlockInteractionCriterion.trigger);
        CriteriaTriggers.func_192118_a(ModuleCraftCriterion.trigger);
        CriteriaTriggers.func_192118_a(ImprovementCraftCriterion.trigger);
        blocks = new Block[]{new BasicWorkbenchBlock(), new GeodeBlock(), new HammerHeadBlock(), new HammerBaseBlock(), new BlockForgedWall(), new BlockForgedPillar(), new BlockForgedPlatform(), new BlockForgedPlatformSlab(), new BlockForgedVent(), new ForgedWorkbenchBlock(), new ForgedContainerBlock(), new BlockForgedCrate(), new TransferUnitBlock(), new CoreExtractorBaseBlock(), new CoreExtractorPistonBlock(), new CoreExtractorPipeBlock(), new SeepingBedrockBlock(), new RackBlock()};
        items = new Item[]{new ModularBladedItem(), new ModularDoubleHeadedItem(), new GeodeItem(), new PristineLapisItem(), new PristineEmeraldItem(), new PristineDiamondItem(), new ModularToolbeltItem(), new ItemCellMagmatic(), new ItemBolt(), new ItemBeam(), new ItemMesh(), new ItemQuickLatch(), new ItemMetalScrap(), new ItemVentPlate(), new JournalItem(), new ModularHolosphereItem(), new EarthpiercerItem()};
        if (((Boolean)ConfigHandler.enableBow.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularBowItem()});
        }
        if (((Boolean)ConfigHandler.enableSingle.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularSingleHeadedItem()});
        }
        if (((Boolean)ConfigHandler.enableShield.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularShieldItem()});
        }
        if (((Boolean)ConfigHandler.enableStonecutter.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new StonecutterItem()});
        }
        proxy.preInit((ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
    }

    public void setup(FMLCommonSetupEvent event) {
        proxy.init(event, (ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
        PacketHandler packetHandler = new PacketHandler();
        Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).forEach(item -> item.init(packetHandler));
        Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).forEach(block -> block.init(packetHandler));
        packetHandler.registerPacket(HonePacket.class, HonePacket::new);
        packetHandler.registerPacket(SettlePacket.class, SettlePacket::new);
        packetHandler.registerPacket(UpdateDataPacket.class, UpdateDataPacket::new);
        packetHandler.registerPacket(SecondaryAbilityPacket.class, SecondaryAbilityPacket::new);
        WorkbenchTile.init(packetHandler);
        proxy.postInit();
        DestabilizationEffect.init();
        SchemaRegistry.instance.registerSchema(new CleanseSchema());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerAboutToStartEvent event) {
        FeatureEntry.instance.setup(event.getServer());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        ModuleDevCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        TGenCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void provideTextures(TextureStitchEvent.Pre event) {
        if (AtlasTexture.field_110575_b.equals((Object)event.getMap().func_229223_g_())) {
            Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/items/module", s -> s.endsWith(".png")).stream().filter(resourceLocation -> MOD_ID.equals(resourceLocation.func_110624_b())).map(rl -> new ResourceLocation(rl.func_110624_b(), rl.func_110623_a().substring(9, rl.func_110623_a().length() - 4))).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            event.addSprite(ForgedContainerTESR.material.func_229313_b_());
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new ModuleProvider(dataGenerator, event.getExistingFileHelper()));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new FeatureEntry());
        }

        @SubscribeEvent
        public static void registerEffects(RegistryEvent.Register<Effect> event) {
            event.getRegistry().register((IForgeRegistryEntry)new BleedingEffect());
            event.getRegistry().register((IForgeRegistryEntry)new EarthboundEffect());
            event.getRegistry().register((IForgeRegistryEntry)new StunEffect());
        }

        @SubscribeEvent
        public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ContainerType toolbeltContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> ToolbeltContainer.create(windowId, inv)).setRegistryName(TetraMod.MOD_ID, "modular_toolbelt");
            event.getRegistry().register((IForgeRegistryEntry)toolbeltContainerType);
            ContainerType workbenchContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return WorkbenchContainer.create(windowId, pos, inv);
            }).setRegistryName(TetraMod.MOD_ID, "workbench");
            event.getRegistry().register((IForgeRegistryEntry)workbenchContainerType);
            ContainerType forgedContainerContainerType = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return ForgedContainerContainer.create(windowId, pos, inv);
            }).setRegistryName(TetraMod.MOD_ID, "forged_container");
            event.getRegistry().register((IForgeRegistryEntry)forgedContainerContainerType);
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])items);
            Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).filter(ITetraBlock::hasItem).forEach(block -> block.registerItem((IForgeRegistry<Item>)event.getRegistry()));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(WorkbenchTile::new, (Block[])new Block[]{BasicWorkbenchBlock.instance, ForgedWorkbenchBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "workbench"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(HammerBaseTile::new, (Block[])new Block[]{HammerBaseBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "hammer_base"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(HammerHeadTile::new, (Block[])new Block[]{HammerHeadBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "hammer_head"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(TransferUnitTile::new, (Block[])new Block[]{TransferUnitBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "transfer_unit"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CoreExtractorBaseTile::new, (Block[])new Block[]{CoreExtractorBaseBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "core_extractor"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CoreExtractorPistonTile::new, (Block[])new Block[]{CoreExtractorPistonBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "extractor_piston"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(ForgedContainerTile::new, (Block[])new Block[]{ForgedContainerBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "forged_container"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(RackTile::new, (Block[])new Block[]{RackBlock.instance}).func_206865_a(null).setRegistryName(TetraMod.MOD_ID, "rack"));
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.func_220322_a(ThrownModularItemEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ThrownModularItemEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("thrown_modular_item").setRegistryName(TetraMod.MOD_ID, "thrown_modular_item")});
        }
    }
}

