/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mgui.gui.ToggleableSlot;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.network.PacketHandler;

public class ForgedContainerContainer
extends Container {
    @ObjectHolder(value="tetra:forged_container")
    public static ContainerType<ForgedContainerContainer> type;
    private ForgedContainerTile tile;
    private ToggleableSlot[][] compartmentSlots;
    private int currentCompartment = 0;

    public ForgedContainerContainer(int windowId, ForgedContainerTile tile, IInventory playerInventory, PlayerEntity player) {
        super(type, windowId);
        int i;
        this.tile = tile;
        tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.compartmentSlots = new ToggleableSlot[ForgedContainerTile.compartmentCount][];
            for (int i = 0; i < this.compartmentSlots.length; ++i) {
                this.compartmentSlots[i] = new ToggleableSlot[ForgedContainerTile.compartmentSize];
                int offset = i * ForgedContainerTile.compartmentSize;
                for (int j = 0; j < 6; ++j) {
                    for (int k = 0; k < 9; ++k) {
                        int index = j * 9 + k;
                        this.compartmentSlots[i][index] = new ToggleableSlot(handler, index + offset, k * 17 + 12, j * 17);
                        this.compartmentSlots[i][index].toggle(i == 0);
                        this.func_75146_a((Slot)this.compartmentSlots[i][index]);
                    }
                }
            }
        });
        InvWrapper playerInventoryHandler = new InvWrapper(playerInventory);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, i * 9 + j + 9, j * 17 + 12, i * 17 + 116));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, i, i * 17 + 12, 171));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ForgedContainerContainer create(int windowId, BlockPos pos, PlayerInventory inv) {
        ForgedContainerTile te = (ForgedContainerTile)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        return new ForgedContainerContainer(windowId, te, (IInventory)inv, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void changeCompartment(int compartmentIndex) {
        this.currentCompartment = compartmentIndex;
        for (int i = 0; i < this.compartmentSlots.length; ++i) {
            boolean enabled = i == compartmentIndex;
            Arrays.stream(this.compartmentSlots[i]).forEach(slot -> slot.toggle(enabled));
        }
        if (this.tile.func_145831_w().field_72995_K) {
            PacketHandler.sendToServer(new ChangeCompartmentPacket(compartmentIndex));
        }
    }

    private int getSlots() {
        return (Integer)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse((Object)0);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack resultStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            resultStack = slotStack.func_77946_l();
            if (index < this.getSlots() ? !this.func_75135_a(slotStack, this.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, this.currentCompartment * ForgedContainerTile.compartmentSize, (this.currentCompartment + 1) * ForgedContainerTile.compartmentSize, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return resultStack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ForgedContainerContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v()), (PlayerEntity)playerIn, (Block)ForgedContainerBlock.instance);
    }

    public ForgedContainerTile getTile() {
        return this.tile;
    }
}

