/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiTabVerticalGroup;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;

@OnlyIn(value=Dist.CLIENT)
public class ForgedContainerScreen
extends ContainerScreen<ForgedContainerContainer> {
    private static final ResourceLocation containerTexture = new ResourceLocation("tetra", "textures/gui/forged-container.png");
    private static final ResourceLocation playerInventoryTexture = new ResourceLocation("tetra", "textures/gui/player-inventory.png");
    private final ForgedContainerTile tileEntity;
    private final ForgedContainerContainer container;
    private final GuiElement guiRoot;
    private final AnimationChain slotTransition;
    private final GuiTabVerticalGroup compartmentButtons;

    public ForgedContainerScreen(ForgedContainerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 179;
        this.field_147000_g = 176;
        this.tileEntity = container.getTile();
        this.container = container;
        this.guiRoot = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.guiRoot.addChild((GuiElement)new GuiTexture(0, -13, 179, 128, containerTexture));
        this.guiRoot.addChild((GuiElement)new GuiTexture(0, 103, 179, 106, playerInventoryTexture));
        this.compartmentButtons = new GuiTabVerticalGroup(10, 26, this::changeCompartment, (String[])IntStream.range(1, ForgedContainerTile.compartmentCount + 1).mapToObj(i -> I18n.func_135052_a((String)"tetra.forged_container.compartment", (Object[])new Object[]{i})).toArray(String[]::new));
        this.guiRoot.addChild((GuiElement)this.compartmentButtons);
        GuiRect slotTransitionElement = new GuiRect(12, 0, 152, 101, 0);
        slotTransitionElement.setOpacity(0.0f);
        this.guiRoot.addChild((GuiElement)slotTransitionElement);
        this.slotTransition = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(30, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.3f)}), new KeyframeAnimation(50, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
    }

    private void changeCompartment(int index) {
        this.container.changeCompartment(index);
        this.compartmentButtons.setActive(index);
        this.slotTransition.stop();
        this.slotTransition.start();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        return this.guiRoot.onClick((int)mouseX, (int)mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.guiRoot.mouseReleased((int)mouseX, (int)mouseY);
        return true;
    }

    public boolean charTyped(char typecChar, int keyCode) {
        this.compartmentButtons.keyTyped(typecChar);
        return false;
    }

    public void tick() {
        super.tick();
        int size = ForgedContainerTile.compartmentSize;
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            for (int i = 0; i < ForgedContainerTile.compartmentCount; ++i) {
                boolean hasContent = false;
                for (int j = 0; j < size; ++j) {
                    if (itemHandler.getStackInSlot(i * size + j).func_190926_b()) continue;
                    hasContent = true;
                    break;
                }
                this.compartmentButtons.setHasContent(i, hasContent);
            }
        });
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.guiRoot.draw(new MatrixStack(), x, y, this.width, this.height, mouseX, mouseY, 1.0f);
    }
}

