/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;

@OnlyIn(value=Dist.CLIENT)
public class ForgedContainerTESR
extends TileEntityRenderer<ForgedContainerTile> {
    public static final Material material = new Material(AtlasTexture.field_110575_b, new ResourceLocation("tetra", "blocks/forged_container/forged_container"));
    public ModelRenderer lid = new ModelRenderer(128, 64, 0, 0);
    public ModelRenderer base;
    public ModelRenderer[] locks;
    private static final float openDuration = 300.0f;

    public ForgedContainerTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.lid.func_228301_a_(0.0f, -3.0f, -14.0f, 30.0f, 3.0f, 14.0f, 0.0f);
        this.lid.field_78800_c = 1.0f;
        this.lid.field_78797_d = 7.0f;
        this.lid.field_78798_e = 15.0f;
        this.locks = new ModelRenderer[4];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ModelRenderer(128, 64, 0, 0);
            this.locks[i].func_228301_a_((float)(-2 + i * 6), -1.0f, -14.03f, 2.0f, 3.0f, 1.0f, 0.0f);
            this.locks[i].field_78800_c = 8.0f;
            this.locks[i].field_78797_d = 7.0f;
            this.locks[i].field_78798_e = 15.0f;
        }
        this.base = new ModelRenderer(128, 64, 0, 17);
        this.base.func_228301_a_(0.0f, 1.0f, 0.0f, 30.0f, 9.0f, 14.0f, 0.0f);
        this.base.field_78800_c = 1.0f;
        this.base.field_78797_d = 6.0f;
        this.base.field_78798_e = 1.0f;
    }

    public void render(ForgedContainerTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile.isFlipped()) {
            return;
        }
        if (tile.func_145830_o()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tile.getFacing().func_185119_l()));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            IVertexBuilder vertexBuilder = material.func_229311_a_(renderTypeBuffer, RenderType::func_228634_a_);
            this.renderLid(tile, partialTicks, matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.renderLocks(tile, partialTicks, matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.base.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            matrixStack.func_227865_b_();
        }
    }

    private void renderLid(ForgedContainerTile tile, float partialTicks, MatrixStack matrixStack, IVertexBuilder vertexBuilder, int combinedLight, int combinedOverlay) {
        if (tile.isOpen()) {
            float progress = Math.min(1.0f, (float)(System.currentTimeMillis() - tile.openTime) / 300.0f);
            this.lid.field_78796_g = progress * 0.1f * 1.5707964f;
            matrixStack.func_227861_a_(0.0, 0.0, (double)(0.3f * progress));
            this.lid.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            matrixStack.func_227861_a_(0.0, 0.0, (double)(-0.3f * progress));
        } else {
            this.lid.field_78796_g = 0.0f;
            this.lid.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        }
    }

    private void renderLocks(ForgedContainerTile tile, float partialTicks, MatrixStack matrixStack, IVertexBuilder vertexBuilder, int combinedLight, int combinedOverlay) {
        Boolean[] locked = tile.isLocked();
        for (int i = 0; i < this.locks.length; ++i) {
            if (!locked[i].booleanValue()) continue;
            this.locks[i].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        }
    }
}

