/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.rack;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;

public class RackTile
extends TileEntity {
    public static final String unlocalizedName = "rack";
    @ObjectHolder(value="tetra:rack")
    public static TileEntityType<RackTile> type;
    private static final String inventoryKey = "inv";
    public static final int inventorySize = 2;
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(2));

    public RackTile() {
        super(type);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void slotInteract(int slot, PlayerEntity playerEntity, Hand hand) {
        this.handler.ifPresent(handler -> {
            ItemStack slotStack = handler.getStackInSlot(slot);
            ItemStack heldStack = playerEntity.func_184586_b(hand);
            if (slotStack.func_190926_b()) {
                ItemStack remainder = handler.insertItem(slot, heldStack.func_77946_l(), false);
                playerEntity.func_184611_a(hand, remainder);
            } else {
                ItemStack extractedStack = handler.extractItem(slot, handler.getSlotLimit(slot), false);
                if (playerEntity.field_71071_by.func_70441_a(extractedStack)) {
                    playerEntity.func_184185_a(SoundEvents.field_187638_cR, 0.5f, 1.0f);
                } else {
                    playerEntity.func_71019_a(extractedStack, false);
                }
            }
        });
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return VoxelShapes.func_197868_b().func_197752_a().func_186670_a(this.field_174879_c);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l(inventoryKey)));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.handler.ifPresent(handler -> compound.func_218657_a(inventoryKey, (INBT)handler.serializeNBT()));
        return compound;
    }
}

