/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;

public class GuiInteractiveCapability
extends GuiElement {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/block-interaction.png");
    private GuiTexture iconTexture;
    private GuiTexture levelTexture;
    private KeyframeAnimation show;
    private KeyframeAnimation hide;
    private Capability capability;
    private int capabilityLevel;
    private PlayerEntity player;

    public GuiInteractiveCapability(int x, int y, Capability capability, int capabilityLevel, PlayerEntity player) {
        super(x, y, 10, 10);
        this.opacity = 0.0f;
        this.capability = capability;
        this.capabilityLevel = capabilityLevel;
        this.player = player;
        this.iconTexture = new GuiTexture(1, 0, 8, 8, capability.ordinal() * 8, 8, texture);
        this.addChild((GuiElement)this.iconTexture);
        this.levelTexture = new GuiTexture(2, 6, 5, 5, (capabilityLevel - 1) * 5, 21, texture);
        this.addChild((GuiElement)this.levelTexture);
        this.show = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).withDelay(650);
        this.hide = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f)});
        this.updateTint();
    }

    public void updateFadeTime() {
        this.show = this.show.withDelay(0);
    }

    private void updateTint() {
        int mainHandLevel = CapabilityHelper.getItemCapabilityLevel(this.player.func_184614_ca(), this.capability);
        int offHandLevel = CapabilityHelper.getItemCapabilityLevel(this.player.func_184592_cb(), this.capability);
        if (mainHandLevel >= this.capabilityLevel || offHandLevel >= this.capabilityLevel) {
            this.levelTexture.setColor(0xFFFFFF);
        } else if (CapabilityHelper.getPlayerCapabilityLevel(this.player, this.capability) >= this.capabilityLevel) {
            this.levelTexture.setColor(0xFFFF00);
        } else {
            this.levelTexture.setColor(0xFF5555);
        }
    }

    public void show() {
        this.updateTint();
        this.hide.stop();
        this.show.start();
    }

    public void hide() {
        this.show.stop();
        this.hide.start();
    }
}

