/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.util.TileEntityOptional;

public abstract class AbstractWorkbenchBlock
extends TetraBlock {
    public AbstractWorkbenchBlock(Block.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(te -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).ifPresent(cap -> {
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack itemStack = cap.getStackInSlot(i);
                    if (itemStack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack.func_77946_l());
                }
            });
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    @Override
    public Collection<Capability> getCapabilities(World world, BlockPos pos, BlockState blockState) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 2, 1)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideCapabilities(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getCapabilities(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public int getCapabilityLevel(World world, BlockPos pos, BlockState blockState, Capability capability) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 2, 1)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideCapabilities(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getCapabilityLevel(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), capability)).max(Integer::compare).orElse(-1);
    }

    private Pair<BlockPos, BlockState> getProvidingBlockstate(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, Capability capability, int level) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 2, 1)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideCapabilities(world, (BlockPos)pair.getFirst(), pos)).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getCapabilityLevel(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), capability) >= level).findFirst().orElse(null);
    }

    @Override
    public ItemStack onCraftConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, Capability requiredCapability, int requiredLevel, boolean consumeResources) {
        Pair<BlockPos, BlockState> provider = this.getProvidingBlockstate(world, pos, blockState, targetStack, requiredCapability, requiredLevel);
        if (provider != null) {
            ITetraBlock block = (ITetraBlock)((BlockState)provider.getSecond()).func_177230_c();
            return block.onCraftConsumeCapability(world, (BlockPos)provider.getFirst(), (BlockState)provider.getSecond(), targetStack, player, requiredCapability, requiredLevel, consumeResources);
        }
        return null;
    }

    @Override
    public ItemStack onActionConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, Capability requiredCapability, int requiredLevel, boolean consumeResources) {
        Pair<BlockPos, BlockState> provider = this.getProvidingBlockstate(world, pos, blockState, targetStack, requiredCapability, requiredLevel);
        if (provider != null) {
            ITetraBlock block = (ITetraBlock)((BlockState)provider.getSecond()).func_177230_c();
            return block.onActionConsumeCapability(world, (BlockPos)provider.getFirst(), (BlockState)provider.getSecond(), targetStack, player, requiredCapability, requiredLevel, consumeResources);
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WorkbenchTile();
    }
}

