/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiKeybinding;
import se.mickelus.tetra.gui.GuiTextures;

public class GuiSlotTabButton
extends GuiClickable {
    private boolean hasContent = false;
    private boolean isActive;
    private GuiRect indicator;
    private GuiTexture icon;
    private GuiString label;
    private GuiKeybinding keybinding;
    private AnimationChain indicatorFlash;
    private AnimationChain iconFlash;
    private KeyframeAnimation labelShow;
    private KeyframeAnimation labelHide;
    private KeyframeAnimation keybindShow;
    private KeyframeAnimation keybindHide;

    public GuiSlotTabButton(int x, int y, int i, String label, String keybinding, boolean initiallyActive, Runnable onClickHandler) {
        super(x, y, 0, 15, onClickHandler);
        this.setAttachmentPoint(GuiAttachment.topRight);
        this.indicator = new GuiRect(0, 0, 1, 15, 0xFFFFFF);
        this.indicator.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.indicator);
        this.indicatorFlash = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(40, (GuiElement)this.indicator).applyTo(new Applier[]{new Applier.TranslateX(-3.0f)}), new KeyframeAnimation(60, (GuiElement)this.indicator).applyTo(new Applier[]{new Applier.TranslateX(0.0f)})});
        this.icon = new GuiTexture(-3, 3, 10, 9, 128 + i * 16, 32, GuiTextures.workbench);
        this.icon.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.icon);
        this.iconFlash = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(40, (GuiElement)this.icon).applyTo(new Applier[]{new Applier.TranslateX(-4.0f)}), new KeyframeAnimation(60, (GuiElement)this.icon).applyTo(new Applier[]{new Applier.TranslateX(-3.0f)})});
        this.label = new GuiString(-16, 4, label);
        this.label.setAttachment(GuiAttachment.topRight);
        this.label.setOpacity(0.0f);
        this.addChild((GuiElement)this.label);
        this.labelShow = new KeyframeAnimation(100, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(-16.0f)});
        this.labelHide = new KeyframeAnimation(150, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-13.0f)});
        this.keybinding = new GuiKeybinding(0, 2, keybinding);
        this.keybinding.setOpacity(0.0f);
        this.keybindShow = new KeyframeAnimation(100, (GuiElement)this.keybinding).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.keybindHide = new KeyframeAnimation(150, (GuiElement)this.keybinding).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(3.0f)});
        this.addChild((GuiElement)this.keybinding);
        this.width = this.label.getWidth() + 20;
        this.isActive = initiallyActive;
        this.updateStyling();
    }

    private void updateStyling() {
        if (this.isActive) {
            this.indicator.setOpacity(1.0f);
            this.icon.setColor(this.hasFocus() ? 0xFFFFCC : 0xFFFFFF);
        } else if (this.hasContent) {
            this.indicator.setOpacity(0.5f);
            this.icon.setColor(this.hasFocus() ? 0x8F8F6F : 0x7F7F7F);
        } else {
            this.indicator.setOpacity(0.25f);
            this.icon.setColor(this.hasFocus() ? 0x8F8F6F : 0x7F7F7F);
        }
        this.indicator.setColor(this.hasFocus() ? 0xFFFFCC : 0xFFFFFF);
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
        this.updateStyling();
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        this.updateStyling();
        if (isActive) {
            this.indicatorFlash.stop();
            this.indicatorFlash.start();
            this.iconFlash.stop();
            this.iconFlash.start();
        }
    }

    protected void onFocus() {
        this.updateStyling();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelShow.start();
        this.keybindShow.start();
    }

    protected void onBlur() {
        this.updateStyling();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelHide.start();
        this.keybindHide.start();
    }
}

