/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.GuiTextureOffset;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.GuiActionList;
import se.mickelus.tetra.blocks.workbench.gui.GuiIntegrityBar;
import se.mickelus.tetra.blocks.workbench.gui.GuiInventoryInfo;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleList;
import se.mickelus.tetra.blocks.workbench.gui.GuiSlotDetail;
import se.mickelus.tetra.blocks.workbench.gui.GuiStatGroup;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

@OnlyIn(value=Dist.CLIENT)
public class WorkbenchScreen
extends ContainerScreen<WorkbenchContainer> {
    private static final ResourceLocation inventoryTexture = new ResourceLocation("tetra", "textures/gui/player-inventory.png");
    private PlayerEntity viewingPlayer;
    private final WorkbenchTile tileEntity;
    private final WorkbenchContainer container;
    private GuiElement defaultGui;
    private GuiModuleList moduleList;
    private GuiStatGroup statGroup;
    private GuiIntegrityBar integrityBar;
    private GuiActionList actionList;
    private final GuiInventoryInfo inventoryInfo;
    private String selectedSlot;
    private int previewMaterialSlot = -1;
    private GuiSlotDetail slotDetail;
    private ItemStack currentTarget = ItemStack.field_190927_a;
    private ItemStack currentPreview = ItemStack.field_190927_a;
    private UpgradeSchema currentSchema = null;
    private ItemStack[] currentMaterials;
    private boolean hadItem = false;

    public WorkbenchScreen(WorkbenchContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 320;
        this.field_147000_g = 240;
        this.tileEntity = container.getTileEntity();
        this.container = container;
        this.defaultGui = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.defaultGui.addChild((GuiElement)new GuiTextureOffset(134, 40, 51, 51, GuiTextures.workbench));
        this.defaultGui.addChild((GuiElement)new GuiTexture(72, 153, 179, 106, inventoryTexture));
        this.moduleList = new GuiModuleList(164, 49, this::selectSlot, this::updateSlotHoverPreview);
        this.defaultGui.addChild((GuiElement)this.moduleList);
        this.statGroup = new GuiStatGroup(60, 0);
        this.defaultGui.addChild((GuiElement)this.statGroup);
        this.integrityBar = new GuiIntegrityBar(160, 90);
        this.defaultGui.addChild((GuiElement)this.integrityBar);
        this.inventoryInfo = new GuiInventoryInfo(84, 164, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.defaultGui.addChild((GuiElement)this.inventoryInfo);
        this.actionList = new GuiActionList(0, 120);
        this.actionList.setAttachmentAnchor(GuiAttachment.topCenter);
        this.actionList.setAttachmentPoint(GuiAttachment.middleCenter);
        this.defaultGui.addChild((GuiElement)this.actionList);
        this.slotDetail = new GuiSlotDetail(46, 102, schema -> this.tileEntity.setCurrentSchema((UpgradeSchema)schema, this.selectedSlot), () -> this.selectSlot(null), this::craftUpgrade, this::previewTweaks, this::applyTweaks);
        this.defaultGui.addChild((GuiElement)this.slotDetail);
        this.tileEntity.addChangeListener("gui.workbench", this::onTileEntityChange);
        this.currentMaterials = new ItemStack[4];
        Arrays.fill(this.currentMaterials, ItemStack.field_190927_a);
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.viewingPlayer = minecraft.field_71439_g;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.defaultGui.draw(new MatrixStack(), x, y, this.width, this.height, mouseX, mouseY, 1.0f);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            tooltipLines = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).collect(Collectors.toList());
            GuiUtils.drawHoveringText(tooltipLines, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.minecraft.field_71466_p);
        }
        this.updateMaterialHoverPreview();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        return this.defaultGui.onClick((int)mouseX, (int)mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.defaultGui.mouseReleased((int)mouseX, (int)mouseY);
        return true;
    }

    public boolean charTyped(char typecChar, int keyCode) {
        this.slotDetail.keyTyped(typecChar);
        return false;
    }

    private void selectSlot(String slotKey) {
        this.selectedSlot = slotKey;
        this.tileEntity.clearSchema();
        this.moduleList.setFocus(this.selectedSlot);
        if (this.selectedSlot != null) {
            this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.tileEntity.getTargetItemStack(), this.selectedSlot, this.tileEntity.getCurrentSchema());
        }
        this.slotDetail.setVisible(this.selectedSlot != null);
    }

    private void deselectSchema() {
        this.tileEntity.clearSchema();
    }

    private void craftUpgrade() {
        this.tileEntity.initiateCrafting(this.viewingPlayer);
    }

    private void previewTweaks(Map<String, Integer> tweakMap) {
        ItemStack previewStack = this.currentTarget.func_77946_l();
        CastOptional.cast(previewStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(previewStack, this.selectedSlot)).ifPresent(module -> tweakMap.forEach((tweakKey, step) -> {
            if (module.hasTweak(previewStack, (String)tweakKey)) {
                module.setTweakStep(previewStack, (String)tweakKey, (int)step);
            }
        }));
        this.statGroup.update(this.currentTarget, previewStack, null, null, this.viewingPlayer);
    }

    private void applyTweaks(Map<String, Integer> tweakMap) {
        this.tileEntity.applyTweaks(this.viewingPlayer, this.selectedSlot, tweakMap);
    }

    private void onTileEntityChange() {
        boolean slotChanged;
        ItemStack newTarget = this.tileEntity.getTargetItemStack();
        ItemStack newPreview = ItemStack.field_190927_a;
        UpgradeSchema newSchema = this.tileEntity.getCurrentSchema();
        String currentSlot = this.tileEntity.getCurrentSlot();
        if (newTarget.func_77973_b() instanceof ModularItem && this.currentSchema != null) {
            newPreview = this.buildPreviewStack(this.currentSchema, newTarget, this.selectedSlot, this.tileEntity.getMaterials());
        }
        boolean targetItemChanged = !ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
        boolean previewChanged = !ItemStack.func_77989_b((ItemStack)this.currentPreview, (ItemStack)newPreview);
        boolean schemaChanged = !Objects.equals(this.currentSchema, newSchema);
        boolean materialsChanged = this.diffMaterials(this.tileEntity.getMaterials());
        this.currentPreview = newPreview;
        this.currentSchema = newSchema;
        if (targetItemChanged) {
            ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
            this.currentTarget = newTarget.func_77946_l();
            this.selectedSlot = null;
        }
        boolean bl = slotChanged = !Objects.equals(this.selectedSlot, currentSlot);
        if (!this.currentTarget.func_190926_b() && currentSlot != null) {
            this.selectedSlot = currentSlot;
        }
        this.container.updateSlots();
        if (slotChanged || targetItemChanged) {
            this.actionList.updateActions(this.currentTarget, this.tileEntity.getAvailableActions(this.viewingPlayer), this.viewingPlayer, action -> this.tileEntity.performAction(this.viewingPlayer, action.getKey()));
        }
        if (targetItemChanged || previewChanged || schemaChanged || slotChanged || materialsChanged) {
            this.updateItemDisplay(this.currentTarget, this.currentPreview);
            if (this.currentTarget.func_77973_b() instanceof ModularItem) {
                this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.currentTarget, this.selectedSlot, this.currentSchema);
            }
        }
        this.inventoryInfo.update(this.currentSchema, currentSlot, this.currentTarget);
        if (!this.currentTarget.func_190926_b()) {
            if (!this.hadItem) {
                this.hadItem = true;
                if (targetItemChanged && currentSlot == null) {
                    this.itemShowAnimation();
                }
            }
        } else {
            this.hadItem = false;
        }
        if (!this.currentTarget.func_190926_b()) {
            if (this.currentSchema == null && this.selectedSlot == null) {
                this.actionList.setVisible(true);
                this.slotDetail.setVisible(false);
            } else if (this.currentTarget.func_77973_b() instanceof ModularItem) {
                this.actionList.setVisible(false);
                this.slotDetail.setVisible(this.selectedSlot != null);
            }
        } else {
            this.actionList.setVisible(false);
            this.slotDetail.setVisible(false);
        }
    }

    private boolean diffMaterials(ItemStack[] newMaterials) {
        int i;
        boolean isDiff = false;
        for (i = 0; i < newMaterials.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)newMaterials[i], (ItemStack)this.currentMaterials[i])) continue;
            isDiff = true;
            break;
        }
        for (i = 0; i < newMaterials.length; ++i) {
            this.currentMaterials[i] = newMaterials[i].func_77946_l();
        }
        return isDiff;
    }

    public void tick() {
        super.tick();
        this.inventoryInfo.update(this.tileEntity.getCurrentSchema(), this.tileEntity.getCurrentSlot(), this.currentTarget);
        World world = this.tileEntity.func_145831_w();
        if (world != null && world.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.tileEntity.func_174877_v();
            int[] availableCapabilities = CapabilityHelper.getCombinedCapabilityLevels(this.viewingPlayer, world, pos, world.func_180495_p(pos));
            if (this.tileEntity.getCurrentSchema() != null && this.slotDetail.isVisible()) {
                this.slotDetail.update(this.viewingPlayer, this.tileEntity, availableCapabilities);
            }
            if (this.actionList.isVisible()) {
                this.actionList.updateCapabilities(availableCapabilities);
            }
        }
    }

    private void updateItemDisplay(ItemStack itemStack, ItemStack previewStack) {
        this.moduleList.update(itemStack, previewStack, this.selectedSlot);
        this.statGroup.update(itemStack, previewStack, null, null, this.viewingPlayer);
        this.integrityBar.setItemStack(itemStack, previewStack);
        this.slotDetail.updatePreview(this.currentSchema, this.selectedSlot, itemStack, previewStack);
    }

    private void itemShowAnimation() {
        this.moduleList.showAnimation();
        this.statGroup.showAnimation();
        this.integrityBar.showAnimation();
        this.actionList.showAnimation();
    }

    private void updateSlotHoverPreview(String slot, String improvement) {
        if (this.tileEntity.getCurrentSlot() == null) {
            ItemStack itemStack = this.tileEntity.getTargetItemStack();
            this.statGroup.update(itemStack, ItemStack.field_190927_a, slot, improvement, this.viewingPlayer);
        }
    }

    private void updateMaterialHoverPreview() {
        int newPreviewMaterialSlot = -1;
        Slot hoveredSlot = this.getSlotUnderMouse();
        UpgradeSchema currentSchema = this.tileEntity.getCurrentSchema();
        ItemStack targetStack = this.tileEntity.getTargetItemStack();
        if (currentSchema != null && hoveredSlot != null && hoveredSlot.func_75216_d()) {
            newPreviewMaterialSlot = hoveredSlot.getSlotIndex();
        }
        if (newPreviewMaterialSlot != this.previewMaterialSlot && targetStack.func_77973_b() instanceof ModularItem) {
            ItemStack[] materials = this.tileEntity.getMaterials();
            if (newPreviewMaterialSlot != -1 && Arrays.stream(materials).allMatch(ItemStack::func_190926_b)) {
                ItemStack previewStack = this.buildPreviewStack(currentSchema, targetStack, this.selectedSlot, new ItemStack[]{hoveredSlot.func_75211_c()});
                this.updateItemDisplay(targetStack, previewStack);
            } else {
                ItemStack previewStack = ItemStack.field_190927_a;
                if (currentSchema != null) {
                    previewStack = this.buildPreviewStack(currentSchema, targetStack, this.selectedSlot, materials);
                }
                this.updateItemDisplay(targetStack, previewStack);
            }
            this.previewMaterialSlot = newPreviewMaterialSlot;
        }
    }

    private ItemStack buildPreviewStack(UpgradeSchema schema, ItemStack targetStack, String slot, ItemStack[] materials) {
        if (schema.isMaterialsValid(targetStack, slot, materials)) {
            return schema.applyUpgrade(targetStack, materials, false, this.tileEntity.getCurrentSlot(), null);
        }
        return ItemStack.field_190927_a;
    }
}

