/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.capabilities;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.util.CastOptional;

public class CapabilityHelper {
    public static int getItemCapabilityLevel(ItemStack itemStack, Capability capability) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof ICapabilityProvider).map(stack -> ((ICapabilityProvider)stack.func_77973_b()).getCapabilityLevel((ItemStack)stack, capability)).orElse(0);
    }

    public static Set<Capability> getItemCapabilities(ItemStack itemStack) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof ICapabilityProvider).map(stack -> ((ICapabilityProvider)stack.func_77973_b()).getCapabilities((ItemStack)stack)).orElse(Collections.emptySet());
    }

    public static int getPlayerEffectLevel(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ModularItem).map(itemStack -> ((ModularItem)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect)).max(Integer::compare).orElse(0);
    }

    public static double getPlayerEffectEfficiency(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ModularItem).max(Comparator.comparingInt(itemStack -> ((ModularItem)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect))).map(itemStack -> ((ModularItem)itemStack.func_77973_b()).getEffectEfficiency((ItemStack)itemStack, effect)).orElse(0.0);
    }

    public static int getPlayerCapabilityLevel(PlayerEntity player, Capability capability) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).map(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability)).max(Integer::compare).orElse(0);
    }

    public static Set<Capability> getPlayerCapabilities(PlayerEntity player) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).flatMap(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilities((ItemStack)itemStack).stream()).collect(Collectors.toSet());
    }

    public static int getInventoryCapabilityLevel(IInventory inventory, Capability capability) {
        int result = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int comparisonLevel = result;
            result = Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).map(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability)).filter(level -> level > comparisonLevel).orElse(comparisonLevel);
        }
        return result;
    }

    public static Set<Capability> getInventoryCapabilities(IInventory inventory) {
        HashSet<Capability> result = new HashSet<Capability>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).map(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilities((ItemStack)itemStack).stream()).orElseGet(Stream::empty).forEach(result::add);
        }
        return result;
    }

    public static ItemStack getInventoryProvidingItemStack(IInventory inventory, Capability capability, int level) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack result = Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).filter(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability) >= level).orElse(ItemStack.field_190927_a);
            if (result.func_190926_b()) continue;
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack consumeCraftCapabilityInventory(IInventory inventory, PlayerEntity player, ItemStack targetStack, Capability capability, int level, boolean consumeResources) {
        ItemStack itemStack = CapabilityHelper.getInventoryProvidingItemStack(inventory, capability, level);
        if (itemStack.func_77973_b() instanceof ModularItem) {
            return ((ModularItem)itemStack.func_77973_b()).onCraftConsumeCapability(itemStack, targetStack, player, capability, level, consumeResources);
        }
        return null;
    }

    public static ItemStack consumeActionCapabilityInventory(IInventory inventory, PlayerEntity player, ItemStack targetStack, Capability capability, int level, boolean consumeResources) {
        ItemStack itemStack = CapabilityHelper.getInventoryProvidingItemStack(inventory, capability, level);
        if (itemStack.func_77973_b() instanceof ModularItem) {
            return ((ModularItem)itemStack.func_77973_b()).onActionConsumeCapability(itemStack, targetStack, player, capability, level, consumeResources);
        }
        return null;
    }

    private static ItemStack getReplacement(ItemStack itemStack) {
        ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(itemStack);
        if (!replacement.func_190926_b()) {
            return replacement;
        }
        return itemStack;
    }

    public static int getBlockCapabilityLevel(World world, BlockPos pos, BlockState blockStateIn, Capability capability) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getCapabilityLevel(world, pos, blockStateIn, capability)).orElse(0);
    }

    public static Collection<Capability> getBlockCapabilities(World world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getCapabilities(world, pos, blockStateIn)).orElse(Collections.emptyList());
    }

    public static int getToolbeltCapabilityLevel(PlayerEntity player, Capability capability) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> Math.max(CapabilityHelper.getInventoryCapabilityLevel(new QuickslotInventory((ItemStack)toolbeltStack), capability), CapabilityHelper.getInventoryCapabilityLevel(new StorageInventory((ItemStack)toolbeltStack), capability))).orElse(0);
    }

    public static Set<Capability> getToolbeltCapabilities(PlayerEntity player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> Sets.union(CapabilityHelper.getInventoryCapabilities(new QuickslotInventory((ItemStack)toolbeltStack)), CapabilityHelper.getInventoryCapabilities(new StorageInventory((ItemStack)toolbeltStack)))).orElse(Collections.emptySet());
    }

    @Nullable
    public static ItemStack consumeCraftCapabilityToolbelt(PlayerEntity player, ItemStack targetStack, Capability capability, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = CapabilityHelper.consumeCraftCapabilityInventory(quickslotInventory, player, targetStack, capability, level, consumeResources);
            if (result != null) {
                quickslotInventory.func_70296_d();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = CapabilityHelper.consumeCraftCapabilityInventory(quickslotInventory, player, targetStack, capability, level, consumeResources);
            if (result != null) {
                storageInventory.func_70296_d();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack consumeActionCapabilityToolbelt(PlayerEntity player, ItemStack targetStack, Capability capability, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = CapabilityHelper.consumeActionCapabilityInventory(quickslotInventory, player, targetStack, capability, level, consumeResources);
            if (result != null) {
                quickslotInventory.func_70296_d();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = CapabilityHelper.consumeActionCapabilityInventory(quickslotInventory, player, targetStack, capability, level, consumeResources);
            if (result != null) {
                storageInventory.func_70296_d();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack getToolbeltProvidingItemStack(Capability capability, int level, Entity entity) {
        return CastOptional.cast(entity, PlayerEntity.class).map(ToolbeltHelper::findToolbelt).filter(itemStack -> !itemStack.func_190926_b()).map(toolbeltStack -> {
            ItemStack itemStack = CapabilityHelper.getInventoryProvidingItemStack(new QuickslotInventory((ItemStack)toolbeltStack), capability, level);
            if (!itemStack.func_190926_b()) {
                return itemStack;
            }
            return CapabilityHelper.getInventoryProvidingItemStack(new StorageInventory((ItemStack)toolbeltStack), capability, level);
        }).orElse(ItemStack.field_190927_a);
    }

    public static int getCombinedCapabilityLevel(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn, Capability capability) {
        return IntStream.of(CapabilityHelper.getPlayerCapabilityLevel(player, capability), CapabilityHelper.getToolbeltCapabilityLevel(player, capability), CapabilityHelper.getBlockCapabilityLevel(world, pos, blockStateIn, capability)).max().orElse(0);
    }

    public static int[] getCombinedCapabilityLevels(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn) {
        return Arrays.stream(Capability.values()).mapToInt(capability -> CapabilityHelper.getCombinedCapabilityLevel(player, world, pos, blockStateIn, capability)).toArray();
    }

    public static ItemStack getPlayerProvidingItemStack(Capability capability, int level, Entity entity) {
        return CastOptional.cast(entity, PlayerEntity.class).map(player -> Stream.concat(Stream.of(player.func_184614_ca(), player.func_184592_cb()), player.field_71071_by.field_70462_a.stream())).orElse(Stream.empty()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).filter(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability) >= level).findAny().orElse(ItemStack.field_190927_a);
    }
}

