/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.provider.EnchantmentBuilder;

public class EnchantmentProvider
implements IDataProvider {
    private static final Logger logger = LogManager.getLogger();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String lang = "en_us";
    private List<EnchantmentBuilder> builders;

    public EnchantmentProvider(DataGenerator generator, ExistingFileHelper exFileHelper) {
        this.generator = generator;
        this.builders = new LinkedList<EnchantmentBuilder>();
    }

    private void setup() {
        this.setupEnchantment(Enchantments.field_185296_A);
        this.setupEnchantment(Enchantments.field_190940_C);
        this.setupEnchantment(Enchantments.field_185302_k).setApply(false).setCreateImprovements(false);
        this.setupEnchantment(Enchantments.field_185303_l);
        this.setupEnchantment(Enchantments.field_180312_n);
        this.setupEnchantment(Enchantments.field_180313_o);
        this.setupEnchantment(Enchantments.field_77334_n);
        this.setupEnchantment(Enchantments.field_185304_p);
        this.setupEnchantment(Enchantments.field_191530_r).setApply(false).setCreateImprovements(false);
        this.setupEnchantment(Enchantments.field_203193_C);
        this.setupEnchantment(Enchantments.field_203194_D);
        this.setupEnchantment(Enchantments.field_203195_E);
        this.setupEnchantment(Enchantments.field_203196_F);
        this.setupEnchantment(Enchantments.field_185305_q).setApply(false).setCreateImprovements(false);
        this.setupEnchantment(Enchantments.field_185306_r);
        this.setupEnchantment(Enchantments.field_185307_s).setApply(false).setCreateImprovements(false);
        this.setupEnchantment(Enchantments.field_185308_t);
        this.setupEnchantment(Enchantments.field_185309_u);
        this.setupEnchantment(Enchantments.field_185310_v);
        this.setupEnchantment(Enchantments.field_185311_w);
        this.setupEnchantment(Enchantments.field_185312_x);
        this.setupEnchantment("apotheosis:capturing");
        this.setupEnchantment("apotheosis:hell_infusion");
        this.setupEnchantment("apotheosis:mounted_strike");
        this.setupEnchantment("apotheosis:depth_miner");
        this.setupEnchantment("apotheosis:stable_footing");
        this.setupEnchantment("apotheosis:scavenger");
        this.setupEnchantment("apotheosis:life_mending");
        this.setupEnchantment("apotheosis:icy_thorns");
        this.setupEnchantment("apotheosis:tempting");
        this.setupEnchantment("apotheosis:shield_bash");
        this.setupEnchantment("apotheosis:reflective");
        this.setupEnchantment("apotheosis:berserk");
        this.setupEnchantment("apotheosis:knowledge");
        this.setupEnchantment("apotheosis:splitting");
        this.setupEnchantment("apotheosis:natures_blessing");
        this.setupEnchantment("apotheosis:rebounding");
        this.setupEnchantment("apotheosis:magic_protection");
        this.setupEnchantment("cyclic:excavate");
        this.setupEnchantment("cyclic:experience_boost");
        this.setupEnchantment("cyclic:life_leech");
        this.setupEnchantment("cyclic:launch");
        this.setupEnchantment("cyclic:magnet");
        this.setupEnchantment("cyclic:multishot");
        this.setupEnchantment("cyclic:quickshot");
        this.setupEnchantment("cyclic:reach");
        this.setupEnchantment("cyclic:venom");
        this.setupEnchantment("cyclic:beheading");
        this.setupEnchantment("cyclic:step");
        this.setupEnchantment("naturesaura:aura_mending");
        this.setupEnchantment("ensorcellation:magic_protection");
        this.setupEnchantment("ensorcellation:displacement");
        this.setupEnchantment("ensorcellation:fire_rebuke");
        this.setupEnchantment("ensorcellation:frost_rebuke");
        this.setupEnchantment("ensorcellation:air_affinity");
        this.setupEnchantment("ensorcellation:exp_boost");
        this.setupEnchantment("ensorcellation:gourmand");
        this.setupEnchantment("ensorcellation:reach");
        this.setupEnchantment("ensorcellation:vitality");
        this.setupEnchantment("ensorcellation:damage_ender");
        this.setupEnchantment("ensorcellation:damage_illager");
        this.setupEnchantment("ensorcellation:damage_villager");
        this.setupEnchantment("ensorcellation:cavalier");
        this.setupEnchantment("ensorcellation:frost_aspect");
        this.setupEnchantment("ensorcellation:leech");
        this.setupEnchantment("ensorcellation:magic_edge");
        this.setupEnchantment("ensorcellation:vorpal");
        this.setupEnchantment("ensorcellation:excavating");
        this.setupEnchantment("ensorcellation:hunter");
        this.setupEnchantment("ensorcellation:quick_draw");
        this.setupEnchantment("ensorcellation:trueshot");
        this.setupEnchantment("ensorcellation:volley");
        this.setupEnchantment("ensorcellation:angler");
        this.setupEnchantment("ensorcellation:pilfering");
        this.setupEnchantment("ensorcellation:furrowing");
        this.setupEnchantment("ensorcellation:tilling");
        this.setupEnchantment("ensorcellation:weeding");
        this.setupEnchantment("ensorcellation:bulwark");
        this.setupEnchantment("ensorcellation:phalanx");
        this.setupEnchantment("ensorcellation:soulbound");
        this.setupEnchantment("ensorcellation:curse_fool");
        this.setupEnchantment("ensorcellation:curse_mercy");
        this.setupEnchantment("bluepower:vorpal");
        this.setupEnchantment("bluepower:disjunction");
        this.setupEnchantment("enchantable:stomping");
        this.setupEnchantment("enchantable:iron_skull");
        this.setupEnchantment("enchantable:replanting");
        this.setupEnchantment("enchantable:cultivator");
        this.setupEnchantment("enchantable:excavator");
        this.setupEnchantment("enchantable:ore_eater");
        this.setupEnchantment("ma-enchants:curse_breaking");
        this.setupEnchantment("ma-enchants:curse_butterfingers");
        this.setupEnchantment("ma-enchants:curse_aquaphobia");
        this.setupEnchantment("ma-enchants:curse_death");
        this.setupEnchantment("ma-enchants:reinforced_tip");
        this.setupEnchantment("ma-enchants:stone_mending");
        this.setupEnchantment("ma-enchants:lumberjack");
        this.setupEnchantment("ma-enchants:momentum");
        this.setupEnchantment("ma-enchants:butchering");
        this.setupEnchantment("ma-enchants:true_shot");
        this.setupEnchantment("ma-enchants:quick_draw");
        this.setupEnchantment("ma-enchants:floating");
        this.setupEnchantment("ma-enchants:paralysis");
        this.setupEnchantment("ma-enchants:detonation");
        this.setupEnchantment("ma-enchants:combo");
        this.setupEnchantment("ma-enchants:faster_attack");
        this.setupEnchantment("ma-enchants:lifesteal");
        this.setupEnchantment("ma-enchants:ice_aspect");
        this.setupEnchantment("ma-enchants:wisdom");
        this.setupEnchantment("ma-enchants:blazing_walker");
        this.setupEnchantment("ma-enchants:step_assist");
        this.setupEnchantment("ma-enchants:night_vision");
        this.setupEnchantment("ma-enchants:multi_jump");
        this.setupEnchantment("ma-enchants:timeless");
        this.setupEnchantment("cursed:blindness");
        this.setupEnchantment("cursed:curtail");
        this.setupEnchantment("cursed:echo");
        this.setupEnchantment("cursed:encumbrance");
        this.setupEnchantment("cursed:fading");
        this.setupEnchantment("cursed:fragility");
        this.setupEnchantment("cursed:ignorance");
        this.setupEnchantment("cursed:insomnia");
        this.setupEnchantment("cursed:misfortune");
        this.setupEnchantment("cursed:obedience");
        this.setupEnchantment("cursed:radiance");
        this.setupEnchantment("cursed:silence");
        this.setupEnchantment("cursed:sinking");
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.setup();
        JsonObject localization = new JsonObject();
        JsonObject missingLocalization = new JsonObject();
        this.builders.stream().collect(Collectors.groupingBy(EnchantmentBuilder::getModId)).forEach((mod, builders) -> {
            JsonArray enchantments = new JsonArray();
            JsonArray destabilization = new JsonArray();
            for (EnchantmentBuilder builder2 : builders) {
                enchantments.add((JsonElement)builder2.getEnchantmentJson());
                if (builder2.canDestabilize()) {
                    enchantments.add((JsonElement)builder2.getEnchantmentDestabilizationJson());
                    destabilization.add((JsonElement)builder2.getDestabilizationJson());
                } else if (builder2.isDestabilizingCurse()) {
                    destabilization.add((JsonElement)builder2.getDestabilizationJson());
                }
                if (!builder2.shouldCreateImprovements()) continue;
                this.saveImprovements(cache, builder2.getKey(), builder2.getImprovementsJson());
            }
            URL locFile = this.getClass().getClassLoader().getResource(String.format("assets/%s/lang/%s.json", mod, "en_us"));
            if (locFile != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(locFile.openStream()));){
                    JsonObject existingLocalization = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    builders.stream().map(builder -> builder.getLocalizationEntries(existingLocalization)).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> {
                        if (!((String)entry.getValue()).isEmpty()) {
                            localization.addProperty((String)entry.getKey(), (String)entry.getValue());
                        } else {
                            missingLocalization.addProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                builders.stream().map(EnchantmentBuilder::getLocalizationKeys).flatMap(Collection::stream).forEach(key -> missingLocalization.addProperty(key, ""));
            }
            this.saveEnchantments(cache, (String)mod, enchantments);
            this.saveDestabilization(cache, (String)mod, destabilization);
        });
        this.saveLocalization(cache, localization);
        this.saveMissingLocalization(cache, missingLocalization);
        JsonObject typeMappings = new JsonObject();
        this.builders.stream().collect(Collectors.groupingBy(EnchantmentBuilder::getEnchantmentType)).forEach((enchantmentType, builders) -> {
            JsonArray enchantments = new JsonArray();
            builders.stream().map(EnchantmentBuilder::getKey).map(key -> "tetra:" + key).forEach(arg_0 -> ((JsonArray)enchantments).add(arg_0));
            typeMappings.add(enchantmentType.toString(), (JsonElement)enchantments);
        });
        this.saveImprovementTypeMappings(cache, typeMappings);
    }

    private EnchantmentBuilder setupEnchantment(String enchantmentId) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentId));
        if (enchantment == null) {
            throw new NullPointerException("Missing enchantment '" + enchantmentId + "'");
        }
        EnchantmentBuilder builder = new EnchantmentBuilder(enchantment);
        this.builders.add(builder);
        return builder;
    }

    private EnchantmentBuilder setupEnchantment(Enchantment enchantment) {
        EnchantmentBuilder builder = new EnchantmentBuilder(enchantment);
        this.builders.add(builder);
        return builder;
    }

    private void saveEnchantments(DirectoryCache cache, String modId, JsonArray enchantments) {
        Path outputPath = this.generator.func_200391_b().resolve("data/tetra/enchantments/" + modId + ".json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)enchantments, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save enchantments to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveDestabilization(DirectoryCache cache, String modId, JsonArray destabilization) {
        Path outputPath = this.generator.func_200391_b().resolve("data/tetra/destabilization/" + modId + ".json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)destabilization, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save destabilization to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveImprovements(DirectoryCache cache, String enchantmentKey, JsonArray improvements) {
        Path outputPath = this.generator.func_200391_b().resolve("data/tetra/improvements/" + enchantmentKey + ".json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)improvements, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save improvements to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveLocalization(DirectoryCache cache, JsonObject localizationEntries) {
        Path outputPath = this.generator.func_200391_b().resolve("temp/enchantments_en_us.json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)localizationEntries, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save localization to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveMissingLocalization(DirectoryCache cache, JsonObject localizationEntries) {
        Path outputPath = this.generator.func_200391_b().resolve("temp/missing_localization.json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)localizationEntries, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save missing localization to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveImprovementTypeMappings(DirectoryCache cache, JsonObject mappings) {
        Path outputPath = this.generator.func_200391_b().resolve("temp/enchantment_mappings.json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)mappings, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save missing localization to {}", (Object)outputPath, (Object)e);
        }
    }

    public String func_200397_b() {
        return "tetra enchantment data provider";
    }
}

