/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.provider;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.provider.ModuleProvider;

public class ModuleBuilder {
    public String module;
    public String prefix;
    public String localization;
    public String schemaPath;
    public JsonObject referenceModule;
    public String fallbackReference;
    private int durabilityOffset = 0;
    private float durabilityMultiplier = 1.0f;
    private float speedOffset = 0.0f;
    private float speedMultiplier = 1.0f;
    private int integrityOffset = 0;
    private float countMultiplier = 1.0f;
    private int capabilityOffset = 0;
    private ArrayList<Variant> variants = new ArrayList();
    private Map<ToolType, BlockState> harvestMap;

    public ModuleBuilder(String module, String prefix, String localization, JsonObject referenceModule, String fallbackReference, String schemaPath) {
        this.module = module;
        this.prefix = prefix;
        this.localization = localization;
        this.schemaPath = schemaPath;
        this.referenceModule = referenceModule;
        this.fallbackReference = fallbackReference;
        this.harvestMap = new HashMap<ToolType, BlockState>();
        this.harvestMap.put(ToolType.AXE, Blocks.field_196617_K.func_176223_P());
        this.harvestMap.put(ToolType.PICKAXE, Blocks.field_150348_b.func_176223_P());
        this.harvestMap.put(ToolType.SHOVEL, Blocks.field_150346_d.func_176223_P());
    }

    public ModuleBuilder offsetOutcome(int countMultiplier, int capabilityOffset) {
        this.countMultiplier = countMultiplier;
        this.capabilityOffset = capabilityOffset;
        return this;
    }

    public ModuleBuilder offsetDurability(int flat, float multiplier) {
        this.durabilityOffset = flat;
        this.durabilityMultiplier = multiplier;
        return this;
    }

    public ModuleBuilder offsetSpeed(float flat, float multiplier) {
        this.speedOffset = flat;
        this.speedMultiplier = multiplier;
        return this;
    }

    public ModuleBuilder offsetIntegrity(int integrity) {
        this.integrityOffset = integrity;
        return this;
    }

    public ModuleBuilder addVariant(Material material) {
        this.variants.add(new Variant(material, null));
        return this;
    }

    public ModuleBuilder addVariant(Material material, Pair<String, Integer> ... improvements) {
        this.variants.add(new Variant(material, null, improvements));
        return this;
    }

    public ModuleBuilder addVariant(Material material, String itemId) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            throw new NullPointerException("Missing item '" + itemId + "'");
        }
        this.variants.add(new Variant(material, item));
        return this;
    }

    public ModuleBuilder addVariant(Material material, String itemId, Pair<String, Integer> ... improvements) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            throw new NullPointerException("Missing item '" + itemId + "'");
        }
        this.variants.add(new Variant(material, item, improvements));
        return this;
    }

    private JsonObject getReferenceVariant(JsonObject moduleJson, String[] variantReferences, String fallbackReference) {
        JsonArray variants = moduleJson.getAsJsonArray("variants");
        String[] referenceKeys = (String[])ArrayUtils.add((Object[])variantReferences, (Object)fallbackReference);
        for (int i = 0; i < referenceKeys.length; ++i) {
            for (int j = 0; j < variants.size(); ++j) {
                JsonObject variant = variants.get(j).getAsJsonObject();
                String variantKey = variant.get("key").getAsString();
                if (!variantKey.contains(referenceKeys[i])) continue;
                return variant;
            }
        }
        throw new NullPointerException("Could not find variant reference for: " + this.module);
    }

    public JsonObject getModuleJson() {
        JsonObject result = new JsonObject();
        JsonArray variantsJson = new JsonArray();
        this.variants.stream().map(this::getVariantJson).forEach(arg_0 -> ((JsonArray)variantsJson).add(arg_0));
        result.add("variants", (JsonElement)variantsJson);
        return result;
    }

    private JsonObject getVariantJson(Variant variant) {
        Material material = variant.material;
        Item item = variant.item;
        JsonObject referenceVariant = this.getReferenceVariant(this.referenceModule, variant.material.references, this.fallbackReference);
        JsonObject result = this.deepCopy(referenceVariant);
        result.addProperty("key", this.prefix + "/" + material.key);
        result.getAsJsonObject("glyph").addProperty("tint", Integer.toHexString(material.tint));
        result.getAsJsonArray("models").forEach(model -> model.getAsJsonObject().addProperty("tint", Integer.toHexString(material.materialTint)));
        result.addProperty("magicCapacity", (Number)material.magicCapacity);
        result.addProperty("integrity", (Number)(this.integrityOffset > 0 ? this.integrityOffset + material.integrity : this.integrityOffset - material.integrity));
        if (item != null) {
            ItemStack itemStack = new ItemStack((IItemProvider)item);
            Multimap attributes = itemStack.func_111283_C(EquipmentSlotType.MAINHAND);
            if (result.has("durability")) {
                result.addProperty("durability", (Number)((int)((float)(itemStack.func_77958_k() + this.durabilityOffset) * this.durabilityMultiplier)));
            }
            if (result.has("damage")) {
                double damage = attributes.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).stream().filter(modifier -> AttributeModifier.Operation.ADDITION.equals((Object)modifier.func_220375_c())).mapToDouble(AttributeModifier::func_111164_d).sum();
                result.addProperty("damage", (Number)damage);
            }
            double attackSpeed = attributes.get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a()).stream().filter(modifier -> AttributeModifier.Operation.ADDITION.equals((Object)modifier.func_220375_c())).mapToDouble(AttributeModifier::func_111164_d).sum();
            if (result.has("attackSpeed")) {
                result.addProperty("attackSpeed", (Number)((attackSpeed + 2.4 + (double)this.speedOffset) * (double)this.speedMultiplier));
            }
            if (result.has("capabilities")) {
                JsonObject capabilitiesJson = result.getAsJsonObject("capabilities");
                Set toolTypes = itemStack.getToolTypes();
                if (capabilitiesJson.size() == toolTypes.size()) {
                    toolTypes.forEach(toolType -> {
                        BlockState blockState = this.harvestMap.get(toolType);
                        JsonArray value = new JsonArray();
                        value.add((Number)itemStack.getHarvestLevel(toolType, null, blockState));
                        value.add((Number)(blockState != null ? (double)item.func_150893_a(itemStack, blockState) / (attackSpeed + 4.0) : 0.0));
                        capabilitiesJson.add(toolType.getName(), (JsonElement)value);
                    });
                } else {
                    long averageLevel = Math.round(toolTypes.stream().mapToInt(toolType -> itemStack.getHarvestLevel(toolType, null, this.harvestMap.get(toolType))).average().orElse(0.0));
                    double averageEfficiency = toolTypes.stream().mapToDouble(toolType -> item.func_150893_a(itemStack, this.harvestMap.get(toolType))).average().orElse(0.0) / (attackSpeed + 4.0);
                    JsonArray value = new JsonArray();
                    value.add((Number)averageLevel);
                    value.add((Number)averageEfficiency);
                    for (Map.Entry entry : capabilitiesJson.entrySet()) {
                        capabilitiesJson.add((String)entry.getKey(), (JsonElement)value);
                    }
                }
            }
        }
        return result;
    }

    public JsonObject getSchemaJson() {
        JsonObject result = new JsonObject();
        JsonArray outcomesJson = new JsonArray();
        this.variants.stream().map(this::getOutcomeJson).forEach(arg_0 -> ((JsonArray)outcomesJson).add(arg_0));
        result.add("outcomes", (JsonElement)outcomesJson);
        return result;
    }

    private JsonObject getOutcomeJson(Variant variant) {
        Material material = variant.material;
        JsonObject outcome = new JsonObject();
        JsonObject outcomeMaterial = new JsonObject();
        outcome.add("material", (JsonElement)outcomeMaterial);
        outcomeMaterial.addProperty(material.type, material.itemId);
        if (MathHelper.func_76123_f((float)((float)material.count * this.countMultiplier)) > 1) {
            outcomeMaterial.addProperty("count", (Number)MathHelper.func_76123_f((float)((float)material.count * this.countMultiplier)));
        }
        if (material.capability != null && material.capabilityLevel + this.capabilityOffset > 0) {
            JsonObject requiredCapabilities = new JsonObject();
            outcome.add("requiredCapabilities", (JsonElement)requiredCapabilities);
            requiredCapabilities.addProperty(material.capability.toString(), (Number)(material.capabilityLevel + this.capabilityOffset));
        }
        outcome.addProperty("moduleKey", this.module);
        outcome.addProperty("moduleVariant", this.prefix + "/" + material.key);
        Map<String, Integer> improvementMap = Stream.concat(Arrays.stream(material.improvements), Arrays.stream(variant.improvements)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        if (!improvementMap.isEmpty()) {
            JsonObject improvements = new JsonObject();
            outcome.add("improvements", (JsonElement)improvements);
            for (Map.Entry<String, Integer> improvement : improvementMap.entrySet()) {
                improvements.addProperty(improvement.getKey(), (Number)improvement.getValue());
            }
        }
        return outcome;
    }

    public Map<String, String> getLocalizationEntries() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.variants.forEach(variant -> {
            result.put("tetra.variant." + this.prefix + "/" + variant.material.key, StringUtils.capitalize((String)String.format(this.localization, variant.material.localization)));
            result.put("tetra.variant." + this.prefix + "/" + variant.material.key + ".prefix", StringUtils.capitalize((String)variant.material.localization));
        });
        return result;
    }

    private JsonObject deepCopy(JsonObject object) {
        try {
            return (JsonObject)ModuleProvider.gson.fromJson(ModuleProvider.gson.toJson((JsonElement)object), JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Variant {
        Material material;
        Item item;
        Pair<String, Integer>[] improvements = new Pair[0];

        public Variant(Material material, Item item) {
            this.material = material;
            this.item = item;
        }

        public Variant(Material material, Item item, Pair<String, Integer>[] improvements) {
            this.material = material;
            this.item = item;
            this.improvements = improvements;
        }
    }

    public static class Material {
        String key;
        String localization;
        int tint = 0;
        int materialTint;
        int integrity;
        int magicCapacity;
        String type;
        String itemId;
        int count;
        Capability capability;
        int capabilityLevel;
        Pair<String, Integer>[] improvements = new Pair[0];
        String[] references = new String[0];

        public Material(String key, String localization, int tint, int materialTint, int integrity, int magicCapacity, String type, String itemId, int count, Capability capability, int capabilityLevel, String[] references) {
            this.key = key;
            this.localization = localization;
            this.tint = tint;
            this.materialTint = materialTint;
            this.integrity = integrity;
            this.magicCapacity = magicCapacity;
            this.type = type;
            this.itemId = itemId;
            this.count = count;
            this.capability = capability;
            this.capabilityLevel = capabilityLevel;
            this.references = references;
        }

        public Material(String key, String localization, int tint, int materialTint, int integrity, int magicCapacity, String type, String itemId, int count, Capability capability, int capabilityLevel, String[] references, Pair<String, Integer> ... improvements) {
            this(key, localization, tint, materialTint, integrity, magicCapacity, type, itemId, count, capability, capabilityLevel, references);
            this.improvements = improvements;
        }
    }
}

