/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.provider.ModuleBuilder;

public class ModuleProvider
implements IDataProvider {
    private static final Logger logger = LogManager.getLogger();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private List<ModuleBuilder> builders;
    private ExistingFileHelper existingFileHelper;
    private final String lang = "en_us";

    public ModuleProvider(DataGenerator generator, ExistingFileHelper exFileHelper) {
        this.generator = generator;
        this.existingFileHelper = exFileHelper;
        this.builders = new LinkedList<ModuleBuilder>();
    }

    private void setup() {
        String[] metalReferences = new String[]{"iron"};
        String[] woodReferences = new String[]{"oak", "wooden"};
        String[] gemReferences = new String[]{"diamond"};
        ModuleBuilder.Material platinum = new ModuleBuilder.Material("platinum", "platinum", 0xD6F6FF, 0xD6F6FF, 1, 66, "tag", "forge:ingots/platinum", 1, Capability.hammer, 4, metalReferences);
        ModuleBuilder.Material ruby = new ModuleBuilder.Material("ruby", "ruby", 10701298, 10701298, 1, 60, "tag", "forge:gems/ruby", 1, Capability.hammer, 2, gemReferences, Pair.of((Object)"arrested", (Object)0));
        ModuleBuilder.Material enigmaticIron = new ModuleBuilder.Material("my_metal", "mystic metal", 0xDDEEEE, 0xEEAABB, 2, 88, "item", "mymod:my_metal", 1, Capability.hammer, 1, metalReferences);
        this.setupModule("double/basic_pickaxe", "basic_pickaxe", "%s pick", "basic_pickaxe/iron", "double/basic_pickaxe/basic_pickaxe").offsetDurability(-20, 0.5f).offsetSpeed(0.0f, 0.5f).addVariant(platinum, "minecraft:iron_pickaxe").addVariant(ruby, "minecraft:diamond_pickaxe").addVariant(enigmaticIron, Pair.of((Object)"enchantment/fortune", (Object)1));
        this.setupModule("double/basic_axe", "basic_axe", "%s axe", "basic_axe/iron", "double/basic_axe/basic_axe").offsetOutcome(2, 0).offsetDurability(-20, 0.7f).offsetSpeed(-0.1f, 1.0f).addVariant(platinum, "minecraft:iron_axe").addVariant(ruby, "minecraft:diamond_axe", Pair.of((Object)"enchantment/fire_aspect", (Object)1)).addVariant(enigmaticIron, Pair.of((Object)"enchantment/looting", (Object)1));
        this.setupModule("double/butt", "butt", "%s butt", "butt/iron", "double/butt/butt").offsetOutcome(1, -1).addVariant(platinum).addVariant(ruby).addVariant(enigmaticIron);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.setup();
        this.builders.forEach(builder -> this.saveModule(cache, builder.module, builder.getModuleJson()));
        this.builders.forEach(builder -> this.saveSchema(cache, builder.schemaPath, builder.getSchemaJson()));
        JsonObject localization = new JsonObject();
        this.builders.stream().map(ModuleBuilder::getLocalizationEntries).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> localization.addProperty((String)entry.getKey(), (String)entry.getValue()));
        this.saveLocalization(cache, localization);
    }

    private ModuleBuilder setupModule(String module, String prefix, String localization, String fallbackReference, String schemaPath) {
        JsonObject referenceModule = null;
        try {
            IResource resource = this.existingFileHelper.getResource(new ResourceLocation("tetra", module), ResourcePackType.SERVER_DATA, ".json", "modules");
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));
            referenceModule = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModuleBuilder builder = new ModuleBuilder(module, prefix, localization, referenceModule, fallbackReference, schemaPath);
        this.builders.add(builder);
        return builder;
    }

    private void saveModule(DirectoryCache cache, String moduleKey, JsonObject moduleData) {
        Path outputPath = this.generator.func_200391_b().resolve("data/tetra/modules/" + moduleKey + ".json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)moduleData, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save module data to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveSchema(DirectoryCache cache, String schemaPath, JsonObject schemaData) {
        Path outputPath = this.generator.func_200391_b().resolve("data/tetra/schemas/" + schemaPath + ".json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)schemaData, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save schema data to {}", (Object)outputPath, (Object)e);
        }
    }

    private void saveLocalization(DirectoryCache cache, JsonObject localizationEntries) {
        Path outputPath = this.generator.func_200391_b().resolve("temp/modules_en_us.json");
        try {
            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)localizationEntries, (Path)outputPath);
        }
        catch (IOException e) {
            logger.error("Couldn't save localization to {}", (Object)outputPath, (Object)e);
        }
    }

    public String func_200397_b() {
        return "tetra module data provider";
    }
}

