/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;

public class GuiItemRolling
extends GuiElement {
    private boolean showTooltip = true;
    private boolean showCount = true;
    private GuiItem[] items = new GuiItem[0];

    public GuiItemRolling(int x, int y) {
        super(x, y, 16, 16);
    }

    public GuiItemRolling setTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        return this;
    }

    public GuiItemRolling setCount(boolean showCount) {
        this.showCount = showCount;
        return this;
    }

    public GuiItemRolling setItems(ItemStack[] itemStacks) {
        this.items = (GuiItem[])Arrays.stream(itemStacks).map(itemStack -> new GuiItem(0, 0).setItem(itemStack).setCount(this.showCount)).toArray(GuiItem[]::new);
        return this;
    }

    protected void drawChildren(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.items.length > 0) {
            int offset = (int)(System.currentTimeMillis() / 1000L) % this.items.length;
            this.items[offset].draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        }
    }

    public List<String> getTooltipLines() {
        if (this.showTooltip && this.items.length > 0) {
            int offset = (int)(System.currentTimeMillis() / 1000L) % this.items.length;
            return this.items[offset].getTooltipLines();
        }
        return null;
    }
}

