/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.util.CastOptional;

public class GuiSynergyIndicator
extends GuiElement {
    private static final int activeCoord = 176;
    private static final int inactiveCoord = 186;
    private static final int emptyCoord = 196;
    protected List<String> tooltip;
    protected GuiTexture indicator;
    protected boolean alwaysShowStats;

    public GuiSynergyIndicator(int x, int y) {
        super(x, y, 10, 10);
        this.indicator = new GuiTexture(0, 0, this.width, this.height, 176, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.indicator);
    }

    public GuiSynergyIndicator(int x, int y, boolean alwaysShowStats) {
        this(x, y);
        this.alwaysShowStats = alwaysShowStats;
    }

    public void update(ItemStack itemStack, ItemModule module) {
        String moduleKey = module.getUnlocalizedName();
        String moduleVariant = module.getVariantData((ItemStack)itemStack).key;
        boolean hasActive = this.alwaysShowStats;
        this.tooltip = new ArrayList<String>();
        this.tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.tetra.modular.synergy_indicator.header", (Object[])new Object[0]));
        if (itemStack.func_77973_b() instanceof ModularItem) {
            ModularItem item = (ModularItem)itemStack.func_77973_b();
            Set activeSynergies = Arrays.stream(item.getSynergyData(itemStack)).collect(Collectors.toSet());
            hasActive = hasActive || Arrays.stream(item.getSynergyData(itemStack)).filter(data -> Arrays.asList(data.modules).contains(moduleKey) || Arrays.asList(data.moduleVariants).contains(moduleVariant)).anyMatch(this::providesStats);
            Arrays.stream(item.getAllSynergyData(itemStack)).filter(data -> Arrays.asList(data.modules).contains(moduleKey)).filter(this::providesStats).flatMap(data -> this.getModuleLines(activeSynergies.contains(data), (SynergyData)data).stream()).collect(Collectors.toCollection(() -> this.tooltip));
            Arrays.stream(item.getAllSynergyData(itemStack)).filter(data -> Arrays.asList(data.moduleVariants).contains(moduleVariant)).filter(this::providesStats).flatMap(data -> this.getVariantLines(activeSynergies.contains(data), (SynergyData)data).stream()).collect(Collectors.toCollection(() -> this.tooltip));
        }
        if (this.tooltip.size() <= 1) {
            this.tooltip = Collections.singletonList(TextFormatting.GRAY + I18n.func_135052_a((String)"item.tetra.modular.synergy_indicator.empty", (Object[])new Object[0]));
            this.indicator.setTextureCoordinates(196, 0);
        } else if (!hasActive) {
            this.indicator.setTextureCoordinates(186, 0);
        } else {
            this.indicator.setTextureCoordinates(176, 0);
        }
    }

    public void update(ItemStack itemStack, String slot) {
        CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).ifPresent(module -> this.update(itemStack, (ItemModule)module));
    }

    private boolean providesStats(SynergyData data) {
        return data.damage != 0.0f || data.damageMultiplier != 1.0f || data.attackSpeed != 0.0f || data.attackSpeedMultiplier != 1.0f || data.durability != 0 || data.durabilityMultiplier != 1.0f || data.integrity != 0 || data.integrityMultiplier != 1.0f || !data.effects.valueMap.isEmpty() || !data.effects.efficiencyMap.isEmpty() || !data.capabilities.valueMap.isEmpty() || !data.capabilities.efficiencyMap.isEmpty() || data.magicCapacity != 0;
    }

    private List<String> getVariantLines(boolean isActive, SynergyData data) {
        String header = Arrays.stream(data.moduleVariants).map(key -> I18n.func_135052_a((String)("tetra.variant." + key), (Object[])new Object[0])).collect(Collectors.joining(" + "));
        if (isActive || this.alwaysShowStats) {
            List<String> result = this.getDataLines(data);
            result.add(0, TextFormatting.GREEN + "\u00bb " + TextFormatting.WHITE + header);
            return result;
        }
        return Collections.singletonList(TextFormatting.BOLD + "  " + TextFormatting.DARK_GRAY + header);
    }

    private List<String> getModuleLines(boolean isActive, SynergyData data) {
        String header = Arrays.stream(data.modules).map(key -> I18n.func_135052_a((String)("tetra.module." + key + ".name"), (Object[])new Object[0])).collect(Collectors.joining(" + "));
        if (data.sameVariant) {
            header = header + " " + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"item.tetra.modular.synergy_indicator.variant_same", (Object[])new Object[0]);
        }
        if (isActive || this.alwaysShowStats) {
            List<String> result = this.getDataLines(data);
            result.add(0, TextFormatting.GREEN + "\u00bb " + TextFormatting.WHITE + header);
            return result;
        }
        return Collections.singletonList(TextFormatting.BOLD + "  " + TextFormatting.DARK_GRAY + header);
    }

    private List<String> getDataLines(SynergyData data) {
        ArrayList<String> result = new ArrayList<String>();
        if (data.damage != 0.0f) {
            result.add(this.getValueDouble(data.damage, 0.0) + I18n.func_135052_a((String)"tetra.stats.damage", (Object[])new Object[0]));
        }
        if (data.damageMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.damageMultiplier) + I18n.func_135052_a((String)"tetra.stats.damage", (Object[])new Object[0]));
        }
        if (data.attackSpeed != 0.0f) {
            result.add(this.getValueDouble(data.attackSpeed, 0.0) + I18n.func_135052_a((String)"tetra.stats.speed", (Object[])new Object[0]));
        }
        if (data.attackSpeedMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.attackSpeedMultiplier) + I18n.func_135052_a((String)"tetra.stats.speed", (Object[])new Object[0]));
        }
        if (data.durability != 0) {
            result.add(this.getValueInteger(data.durability, 0) + I18n.func_135052_a((String)"tetra.stats.durability", (Object[])new Object[0]));
        }
        if (data.durabilityMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.durabilityMultiplier) + I18n.func_135052_a((String)"tetra.stats.durability", (Object[])new Object[0]));
        }
        if (data.integrity != 0) {
            result.add(this.getValueInteger(data.integrity, 0) + I18n.func_135052_a((String)"tetra.stats.integrity", (Object[])new Object[0]));
        }
        if (data.integrityMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.integrityMultiplier) + I18n.func_135052_a((String)"tetra.stats.integrity", (Object[])new Object[0]));
        }
        data.effects.valueMap.forEach((itemEffect, level) -> result.add(this.getValueInteger((int)level, 0) + I18n.func_135052_a((String)("tetra.stats." + (Object)itemEffect), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tetra.stats.level_suffix", (Object[])new Object[0])));
        data.effects.efficiencyMap.forEach((itemEffect, efficiency) -> result.add(this.getValueDouble(efficiency.floatValue(), 0.0) + I18n.func_135052_a((String)("tetra.stats." + (Object)itemEffect), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tetra.stats.strength_suffix", (Object[])new Object[0])));
        data.capabilities.valueMap.forEach((capability, level) -> result.add(this.getValueInteger((int)level, 0) + I18n.func_135052_a((String)("tetra.capability." + (Object)capability), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tetra.stats.tier_suffix", (Object[])new Object[0])));
        data.capabilities.efficiencyMap.forEach((capability, efficiency) -> result.add(this.getValueDouble(efficiency.floatValue(), 0.0) + I18n.func_135052_a((String)("tetra.capability." + (Object)capability), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tetra.stats.efficiency_suffix", (Object[])new Object[0])));
        if (data.magicCapacity != 0) {
            result.add(this.getValueDouble(data.integrity, 0.0) + I18n.func_135052_a((String)"tetra.stats.magicCapacity", (Object[])new Object[0]));
        }
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                result.set(i, TextFormatting.GRAY + "  \u2514 " + (String)result.get(i));
                continue;
            }
            result.set(i, TextFormatting.GRAY + "  \u251c " + (String)result.get(i));
        }
        return result;
    }

    public String getValueInteger(int value, int flippingPoint) {
        if (value > flippingPoint) {
            return TextFormatting.GREEN + String.format("%+d ", value) + TextFormatting.RESET;
        }
        return TextFormatting.RED + String.format("%+d ", value) + TextFormatting.RESET;
    }

    public String getValueMultiplier(double value) {
        if (value > 1.0) {
            return TextFormatting.GREEN + String.format("%.02fx ", value) + TextFormatting.RESET;
        }
        return TextFormatting.RED + String.format("%.02fx ", value) + TextFormatting.RESET;
    }

    public String getValueDouble(double value, double flippingPoint) {
        if (value > flippingPoint) {
            return TextFormatting.GREEN + String.format("%+.02f ", value) + TextFormatting.RESET;
        }
        return TextFormatting.RED + String.format("%+.02f ", value) + TextFormatting.RESET;
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

