/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import com.mojang.blaze3d.matrix.MatrixStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiElement;

public class GuiBar
extends GuiElement {
    protected static final int increaseColorBar = -2007629995;
    protected static final int decreaseColorBar = -1996532395;
    protected int diffColor;
    protected double min;
    protected double max;
    protected double value;
    protected double diffValue;
    protected int barLength;
    protected int diffLength;
    protected boolean invertedDiff = false;
    protected GuiAlignment alignment = GuiAlignment.left;

    public GuiBar(int x, int y, int barLength, double min, double max) {
        this(x, y, barLength, min, max, false);
    }

    public GuiBar(int x, int y, int barLength, double min, double max, boolean invertedDiff) {
        super(x, y, barLength, 1);
        this.min = min;
        this.max = max;
        this.invertedDiff = invertedDiff;
    }

    public void setAlignment(GuiAlignment alignment) {
        this.alignment = alignment;
    }

    public void setMin(double min) {
        this.min = min;
        this.calculateBarLengths();
    }

    public void setMax(double max) {
        this.max = max;
        this.calculateBarLengths();
    }

    public void setValue(double value, double diffValue) {
        this.value = Math.min(Math.max(value, this.min), this.max);
        this.diffValue = Math.min(Math.max(diffValue, this.min), this.max);
        this.calculateBarLengths();
    }

    protected void calculateBarLengths() {
        double minValue = Math.min(this.value, this.diffValue);
        this.barLength = (int)Math.floor((minValue - this.min) / (this.max - this.min) * (double)this.width);
        this.diffLength = (int)Math.ceil(Math.abs(this.value - this.diffValue) / (this.max - this.min) * (double)this.width);
        this.diffColor = this.invertedDiff ^ this.value < this.diffValue ? -2007629995 : -1996532395;
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        GuiBar.drawRect((MatrixStack)matrixStack, (int)(refX + this.x), (int)(refY + this.y + 6), (int)(refX + this.x + this.width), (int)(refY + this.y + 6 + this.height), (int)0xFFFFFF, (float)(0.14f * opacity));
        if (this.alignment == GuiAlignment.right) {
            GuiBar.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + this.width - this.barLength), (int)(refY + this.y + 6), (int)(refX + this.x + this.width), (int)(refY + this.y + 6 + this.height), (int)-1, (float)opacity);
            GuiBar.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + this.width - this.barLength - this.diffLength), (int)(refY + this.y + 6), (int)(refX + this.x + this.width - this.barLength), (int)(refY + this.y + 6 + this.height), (int)this.diffColor, (float)1.0f);
        } else {
            GuiBar.drawRect((MatrixStack)matrixStack, (int)(refX + this.x), (int)(refY + this.y + 6), (int)(refX + this.x + this.barLength), (int)(refY + this.y + 6 + this.height), (int)-1, (float)opacity);
            GuiBar.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + this.barLength), (int)(refY + this.y + 6), (int)(refX + this.x + this.barLength + this.diffLength), (int)(refY + this.y + 6 + this.height), (int)this.diffColor, (float)1.0f);
        }
    }
}

