/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar.getter;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.util.CastOptional;

public class StatGetterEffectEfficiency
implements IStatGetter {
    private ItemEffect effect;
    private double multiplier;
    private double base;

    public StatGetterEffectEfficiency(ItemEffect effect, double multiplier) {
        this(effect, multiplier, 0.0);
    }

    public StatGetterEffectEfficiency(ItemEffect effect, double multiplier, double base) {
        this.effect = effect;
        this.multiplier = multiplier;
        this.base = base;
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getEffectEfficiency(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> (double)module.getEffectEfficiency(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).flatMap(item -> CastOptional.cast(item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class)).map(module -> module.getImprovement(itemStack, improvement)).map(improvementData -> (double)improvementData.effects.getEfficiency(this.effect) * this.multiplier).orElse(0.0);
    }
}

