/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar.getter;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.util.CastOptional;

public class StatGetterEnchantmentLevel
implements IStatGetter {
    private Enchantment enchantment;
    private double multiplier;
    private double base;

    public StatGetterEnchantmentLevel(Enchantment enchantment, double multiplier) {
        this(enchantment, multiplier, 0.0);
    }

    public StatGetterEnchantmentLevel(Enchantment enchantment, double multiplier, double base) {
        this.enchantment = enchantment;
        this.multiplier = multiplier;
        this.base = base;
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> (double)item.getEnchantmentLevelFromImprovements(itemStack, this.enchantment) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> (double)item.getEnchantmentLevelFromImprovements(itemStack, slot, this.enchantment) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> (double)item.getEnchantmentLevelFromImprovements(itemStack, slot, improvement, this.enchantment) * this.multiplier).orElse(0.0);
    }
}

