/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class ThrownModularItemEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "thrown_modular_item";
    public static final String stackKey = "stack";
    public static final String dealtDamageKey = "DealtDamage";
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(ThrownModularItemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> RICOCHET_LEVEL = EntityDataManager.func_187226_a(ThrownModularItemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private ItemStack thrownStack = new ItemStack((IItemProvider)Items.field_203184_eO);
    @ObjectHolder(value="tetra:thrown_modular_item")
    public static EntityType<ThrownModularItemEntity> type;
    private boolean dealtDamage;
    public int returningTicks;
    private IntOpenHashSet hitEntities = new IntOpenHashSet(5);

    public ThrownModularItemEntity(EntityType<? extends ThrownModularItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrownModularItemEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(type, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
        CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).map(item -> item.getEffectLevel(this.thrownStack, ItemEffect.ricochet)).ifPresent(level -> this.field_70180_af.func_187227_b(RICOCHET_LEVEL, (Object)level.byteValue()));
        if (this.thrownStack.func_77973_b() instanceof ModularSingleHeadedItem) {
            this.func_213869_a(SoundEvents.field_203269_ik);
        } else if (this.thrownStack.func_77973_b() instanceof ModularShieldItem) {
            this.func_213869_a(SoundEvents.field_187721_dT);
        } else {
            this.func_213869_a(SoundEvents.field_187733_dX);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ThrownModularItemEntity(World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public ThrownModularItemEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(RICOCHET_LEVEL, (Object)0);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.func_212360_k();
        if ((this.dealtDamage || this.func_203047_q()) && shooter != null) {
            byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyaltyLevel > 0) {
                this.func_203045_n(true);
                Vec3d vec3d = new Vec3d(shooter.func_226277_ct_() - this.func_226277_ct_(), shooter.func_226280_cw_() - this.func_226278_cu_(), shooter.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vec3d.field_72448_b * 0.015 * (double)loyaltyLevel, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double speed = 0.05 * (double)loyaltyLevel;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(speed)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                    this.func_213317_d(vec3d.func_186678_a(0.01));
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_212360_k();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public boolean hasDealtDamage() {
        return this.dealtDamage;
    }

    public boolean isOnGround() {
        return this.field_184552_b > 0;
    }

    public int getRicochetLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(RICOCHET_LEVEL)).byteValue();
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d startVec, Vec3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_184549_a(RayTraceResult rayTraceResult) {
        super.func_184549_a(rayTraceResult);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !this.dealtDamage) {
            float destroySpeed;
            BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            Entity shooter = this.func_212360_k();
            BlockState blockState = this.field_70170_p.func_180495_p(pos);
            if (ForgeHooks.canToolHarvestBlock((IWorldReader)this.field_70170_p, (BlockPos)pos, (ItemStack)this.thrownStack) && shooter instanceof PlayerEntity && (destroySpeed = CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).map(item -> Float.valueOf(item.func_150893_a(this.thrownStack, blockState))).orElse(Float.valueOf(1.0f)).floatValue()) > blockState.func_185887_b((IBlockReader)this.field_70170_p, pos)) {
                if (shooter instanceof ServerPlayerEntity) {
                    ItemEffectHandler.sendEventToPlayer((ServerPlayerEntity)shooter, 2001, pos, Block.func_196246_j((BlockState)blockState));
                }
                CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> item.applyBreakEffects(this.thrownStack, this.field_70170_p, blockState, pos, (LivingEntity)((PlayerEntity)shooter)));
                this.breakBlock((PlayerEntity)shooter, pos, blockState);
                Vec3i faceVec = ((BlockRayTraceResult)rayTraceResult).func_216354_b().func_176730_m();
                this.func_213317_d(new Vec3d(faceVec).func_186678_a(0.1));
                this.dealtDamage = true;
            }
        }
    }

    private void breakBlock(PlayerEntity shooter, BlockPos pos, BlockState blockState) {
        ItemStack currentItem = shooter.func_184614_ca();
        shooter.func_184611_a(Hand.MAIN_HAND, this.thrownStack);
        ItemEffectHandler.breakBlock(this.field_70170_p, shooter, this.thrownStack, pos, blockState, true);
        shooter.func_184611_a(Hand.MAIN_HAND, currentItem);
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        BlockPos blockpos;
        LivingEntity targetLivingEntity;
        Entity target = raytrace.func_216348_a();
        Entity shooter = this.func_212360_k();
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)(shooter == null ? this : shooter));
        if (this.func_213874_s() > 0 || this.getRicochetLevel() > 0) {
            if (this.hitEntities == null) {
                this.hitEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities.contains(target.func_145782_y())) {
                return;
            }
            if (this.hitEntities.size() < this.func_213874_s() || this.hitEntities.size() < this.getRicochetLevel()) {
                this.hitEntities.add(target.func_145782_y());
            } else {
                this.dealtDamage = true;
            }
        } else {
            this.dealtDamage = true;
        }
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        double damage = CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).map(item -> item.getAbilityBaseDamage(this.thrownStack)).orElse(8.0);
        if (target instanceof LivingEntity && target.func_70097_a(damagesource, (float)(damage += (double)EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)(targetLivingEntity = (LivingEntity)target).func_70668_bt())))) {
            if (shooter instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)targetLivingEntity, (Entity)shooter);
                ItemModularHandheld.applyEnchantmentHitEffects(this.func_184550_j(), targetLivingEntity, (LivingEntity)shooter);
            }
            this.func_184548_a(targetLivingEntity);
        }
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.thrownStack) && this.field_70170_p.func_226660_f_(blockpos = target.func_180425_c())) {
            LightningBoltEntity lightningboltentity = new LightningBoltEntity(this.field_70170_p, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, false);
            lightningboltentity.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
            ((ServerWorld)this.field_70170_p).func_217468_a(lightningboltentity);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        if (target instanceof LivingEntity && shooter instanceof LivingEntity) {
            CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> item.applyHitEffects(this.thrownStack, (LivingEntity)target, (LivingEntity)shooter));
        }
        if (shooter instanceof LivingEntity) {
            CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> item.tickProgression((LivingEntity)shooter, this.thrownStack, 1));
        }
        this.func_184185_a(soundevent, f1, 1.0f);
        if (this.dealtDamage) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        } else if (this.getRicochetLevel() > 0 && !this.field_70170_p.field_72995_K) {
            this.func_213317_d(this.field_70170_p.func_175674_a(shooter, new AxisAlignedBB(target.func_180425_c()).func_186662_g(8.0), entity -> !this.hitEntities.contains(entity.func_145782_y()) && entity instanceof LivingEntity && !entity.func_180431_b(damagesource) && (shooter == null || !entity.func_184191_r(shooter))).stream().findFirst().map(entity -> entity.func_180425_c().func_177963_a(0.0, (double)(entity.func_213302_cg() + 1.0f), 0.0)).map(pos -> new Vec3d((Vec3i)pos).func_178788_d(this.func_213303_ch())).map(Vec3d::func_72432_b).map(direction -> direction.func_186678_a(this.func_213322_ci().func_72433_c() * 0.7)).orElse(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01)));
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_212360_k();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(stackKey, 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(stackKey));
        }
        this.dealtDamage = compound.func_74767_n(dealtDamageKey);
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
        CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).map(item -> item.getEffectLevel(this.thrownStack, ItemEffect.ricochet)).ifPresent(level -> this.field_70180_af.func_187227_b(RICOCHET_LEVEL, (Object)level.byteValue()));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a(stackKey, (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a(dealtDamageKey, this.dealtDamage);
    }

    public void func_225516_i_() {
        byte level = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || level <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.thrownStack);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.thrownStack = buffer.func_150791_c();
    }
}

