/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.schema.RemoveSchema;
import se.mickelus.tetra.module.schema.RepairSchema;
import se.mickelus.tetra.network.PacketHandler;

public class ModularDoubleHeadedItem
extends ItemModularHandheld {
    public static final String headLeftKey = "double/head_left";
    public static final String headRightKey = "double/head_right";
    public static final String handleKey = "double/handle";
    public static final String bindingKey = "double/binding";
    public static final String accessoryKey = "double/accessory";
    public static final String leftSuffix = "_left";
    public static final String rightSuffix = "_right";
    private static final String unlocalizedName = "modular_double";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(6, 1);
    @ObjectHolder(value="tetra:modular_double")
    public static ModularDoubleHeadedItem instance;

    public ModularDoubleHeadedItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)TetraItemGroup.instance));
        this.setRegistryName(unlocalizedName);
        this.entityHitDamage = 2;
        this.majorModuleKeys = new String[]{headLeftKey, headRightKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headLeftKey, headRightKey};
        this.updateConfig((Integer)ConfigHandler.honedoubleBase.get(), (Integer)ConfigHandler.honedoubleIntegrityMultiplier.get());
        SchemaRegistry.instance.registerSchema(new RepairSchema(this));
        RemoveSchema.registerRemoveSchemas(this);
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("double");
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.setupHammerStack("log", "stick"));
            items.add((Object)this.setupHammerStack("obsidian", "iron"));
        }
    }

    private ItemStack setupHammerStack(String headMaterial, String handleMaterial) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        ModularDoubleHeadedItem.putModuleInSlot(itemStack, headLeftKey, "double/basic_hammer_left", "double/basic_hammer_left_material", "basic_hammer/" + headMaterial);
        ModularDoubleHeadedItem.putModuleInSlot(itemStack, headRightKey, "double/basic_hammer_right", "double/basic_hammer_right_material", "basic_hammer/" + headMaterial);
        ModularDoubleHeadedItem.putModuleInSlot(itemStack, handleKey, "double/basic_handle", "double/basic_handle_material", "basic_handle/" + handleMaterial);
        return itemStack;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        if (player != null && !player.func_213453_ef() && world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150462_ai) && this.getCapabilityLevel(player.func_184586_b(hand), Capability.hammer) > 0) {
            return BasicWorkbenchBlock.upgradeWorkbench(player, world, pos, hand, context.func_196000_l());
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    protected String getDisplayNamePrefixes(ItemStack itemStack) {
        String modulePrefix = Optional.ofNullable(this.getModuleFromSlot(itemStack, headLeftKey)).map(module -> module.getItemPrefix(itemStack)).map(prefix -> prefix + " ").orElse("");
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().map(prefix -> prefix + " " + modulePrefix).orElse(modulePrefix);
    }

    @Override
    public double getDamageModifier(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        double damageModifier = Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).mapToDouble(module -> module.getDamageModifier(itemStack)).max().orElse(0.0);
        damageModifier = this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(itemModule -> itemModule.getDamageModifier(itemStack)).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damage).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damageMultiplier).reduce(damageModifier, (a, b) -> a * b);
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getDamageMultiplierModifier(itemStack)).reduce(damageModifier, (a, b) -> a * b);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

