/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantItemGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantMajorItemGui;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class HoloVariantsGui
extends GuiElement {
    private GuiElement variantsContainer;
    private HoloVariantItemGui[] variants;
    private KeyframeAnimation labelAnimation;
    private KeyframeAnimation[] itemAnimations;
    private Consumer<OutcomePreview> onVariantHover;
    private Consumer<OutcomePreview> onVariantBlur;
    private Consumer<OutcomePreview> onVariantSelect;

    public HoloVariantsGui(int x, int y, int width, Consumer<OutcomePreview> onVariantHover, Consumer<OutcomePreview> onVariantBlur, Consumer<OutcomePreview> onVariantSelect) {
        super(x, y, width, 50);
        GuiStringSmall variantsLabel = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"tetra.holo.craft.variants", (Object[])new Object[0]));
        variantsLabel.setColor(0x7F7F7F);
        this.addChild((GuiElement)variantsLabel);
        this.variants = new HoloVariantItemGui[0];
        this.variantsContainer = new GuiElement(0, 8, width, this.height);
        this.addChild(this.variantsContainer);
        this.labelAnimation = new KeyframeAnimation(100, (GuiElement)variantsLabel).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)(x - 5), (float)x)});
        this.itemAnimations = new KeyframeAnimation[0];
        this.onVariantHover = onVariantHover;
        this.onVariantBlur = onVariantBlur;
        this.onVariantSelect = onVariantSelect;
    }

    public void update(ModularItem item, String slot, UpgradeSchema schema) {
        this.variantsContainer.clearChildren();
        OutcomePreview[] outcomes = (OutcomePreview[])Arrays.stream(schema.getPreviews(new ItemStack((IItemProvider)item), slot)).filter(preview -> preview.materials.length != 0).toArray(OutcomePreview[]::new);
        this.variants = new HoloVariantItemGui[outcomes.length];
        this.itemAnimations = new KeyframeAnimation[outcomes.length];
        for (int i = 0; i < outcomes.length; ++i) {
            if (SchemaType.minor.equals((Object)outcomes[i].type)) {
                this.variants[i] = new HoloVariantItemGui(i / 2 * 15, i % 2 * 15, outcomes[i], this.onVariantHover, this.onVariantBlur, this.onVariantSelect);
                this.variantsContainer.addChild((GuiElement)this.variants[i]);
                this.itemAnimations[i] = new KeyframeAnimation(80, (GuiElement)this.variants[i]).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(-5.0f, 0.0f, true)}).withDelay(40 + 40 * (i / 2));
                continue;
            }
            this.variants[i] = new HoloVariantMajorItemGui(i / 2 * 20 + i % 2 * 10, i % 2 * 15, outcomes[i], this.onVariantHover, this.onVariantBlur, this.onVariantSelect);
            this.variantsContainer.addChild((GuiElement)this.variants[i]);
            this.itemAnimations[i] = new KeyframeAnimation(80, (GuiElement)this.variants[i]).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(-5.0f, 0.0f, true), new Applier.TranslateY(-5.0f, 0.0f, true)}).withDelay(40 + 40 * (i / 2));
        }
    }

    public void updateSelection(OutcomePreview outcome) {
        for (HoloVariantItemGui variant : this.variants) {
            variant.updateSelection(outcome);
        }
    }

    protected void onShow() {
        this.labelAnimation.start();
        Arrays.stream(this.itemAnimations).forEach(KeyframeAnimation::start);
    }
}

