/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.scan;

import net.minecraft.client.Minecraft;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

public class ScannerBarGui
extends GuiElement {
    private AnimationChain[] upAnimations;
    private AnimationChain[] upHighlightAnimations;
    private AnimationChain[] midAnimations;
    private AnimationChain[] midHighlightAnimations;
    private AnimationChain[] downAnimations;
    private AnimationChain[] downHighlightAnimations;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;
    int horizontalSpread;
    private static final int unitWidth = 6;

    public ScannerBarGui(int x, int y, int horizontalSpread) {
        super(x, y, horizontalSpread * 6, 9);
        this.horizontalSpread = horizontalSpread;
        this.setup();
        this.showAnimation = new KeyframeAnimation(300, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y, (float)(y - 4))});
        this.hideAnimation = new KeyframeAnimation(300, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 4), (float)y)}).withDelay(200);
    }

    private void setup() {
        int i;
        this.setWidth(this.horizontalSpread * 6);
        this.upAnimations = new AnimationChain[this.horizontalSpread];
        this.midAnimations = new AnimationChain[this.horizontalSpread];
        this.downAnimations = new AnimationChain[this.horizontalSpread];
        this.upHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.midHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.downHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.addChild(new GuiRect(-3, -2, this.getWidth() + 3, this.getHeight() + 2, 0).setOpacity(0.5f));
        this.addChild(new GuiTexture(-2, -1, 2, 2, 1, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topLeft));
        this.addChild(new GuiTexture(-2, -1, 2, 2, 1, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomLeft));
        this.addChild(new GuiTexture(-1, -1, 2, 2, 0, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topRight));
        this.addChild(new GuiTexture(-1, -1, 2, 2, 0, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomRight));
        this.addChild(new GuiTexture(-2, -1, 3, 2, 0, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topCenter));
        this.addChild(new GuiTexture(-2, -1, 3, 2, 0, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomCenter));
        for (i = 0; i < this.horizontalSpread; ++i) {
            GuiElement up = new GuiTexture(i * 6, 0, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(up);
            this.upAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, up).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, up).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement upHighlight = new GuiTexture(i * 6, 0, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(upHighlight);
            this.upHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, upHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, upHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
            GuiElement down = new GuiTexture(i * 6, 4, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(down);
            this.downAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, down).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, down).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement downHighlight = new GuiTexture(i * 6, 4, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(downHighlight);
            this.downHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, downHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, downHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        }
        for (i = 0; i < this.horizontalSpread - 1; ++i) {
            GuiElement center = new GuiTexture(i * 6 + 3, 2, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(center);
            this.midAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, center).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, center).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement centerHighlight = new GuiTexture(i * 6 + 3, 2, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(centerHighlight);
            this.midHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, centerHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, centerHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        }
    }

    public static double getDegreesPerUnit() {
        return Minecraft.func_71410_x().field_71474_y.field_74334_X * 6.0 / (double)Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    public void setHorizontalSpread(int horizontalSpread) {
        if (horizontalSpread != 0 && this.horizontalSpread != horizontalSpread) {
            this.horizontalSpread = horizontalSpread;
            this.clearChildren();
            this.setup();
        }
    }

    protected void show() {
        if (this.opacity < 1.0f && !this.showAnimation.isActive()) {
            this.hideAnimation.stop();
            this.showAnimation.start();
        }
    }

    protected boolean hide() {
        if (this.opacity > 0.0f && !this.hideAnimation.isActive()) {
            this.showAnimation.stop();
            this.hideAnimation.start();
        }
        return false;
    }

    public void highlightUp(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.upHighlightAnimations[index].start();
            } else {
                this.upAnimations[index].start();
            }
        }
    }

    public void highlightMid(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.midHighlightAnimations[index].start();
            } else {
                this.midAnimations[index].start();
            }
        }
    }

    public void highlightDown(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.downHighlightAnimations[index].start();
            } else {
                this.downAnimations[index].start();
            }
        }
    }
}

