/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

public class ApplyBannerSchema
implements UpgradeSchema {
    private static final String localizationPrefix = "tetra/schema/";
    private static final String key = "shield/plate/banner";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot1";
    private GlyphData glyph = new GlyphData(GuiTextures.glyphs, 96, 240);

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tetra/schema/shield/plate/banner.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra/schema/shield/plate/banner.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)"tetra/schema/shield/plate/banner.slot1", (Object[])new Object[0]);
    }

    @Override
    public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return new ItemStack[]{Items.field_196191_eg.func_190903_i()};
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 1;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        return materialStack.func_77973_b() instanceof BannerItem;
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, itemSlot, 0, materials[0]);
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ModularShieldItem;
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return "shield/plate".equals(slot);
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return this.isMaterialsValid(itemStack, slot, materials);
    }

    @Override
    public boolean isIntegrityViolation(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ItemStack bannerStack = materials[0];
        if (this.isMaterialsValid(itemStack, slot, materials)) {
            CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).flatMap(module -> CastOptional.cast(module, ItemModuleMajor.class)).ifPresent(module -> {
                if (module.acceptsImprovementLevel("shield/banner", 0)) {
                    module.addImprovement(upgradedStack, "shield/banner", 0);
                    CompoundNBT bannerTag = Optional.ofNullable(bannerStack.func_179543_a("BlockEntityTag")).map(CompoundNBT::func_74737_b).orElse(new CompoundNBT());
                    bannerTag.func_74768_a("Base", ((BannerItem)bannerStack.func_77973_b()).func_195948_b().func_196059_a());
                    upgradedStack.func_77983_a("BlockEntityTag", (INBT)bannerTag.func_74737_b());
                    if (consumeMaterials) {
                        materials[0].func_190918_g(1);
                    }
                    if (consumeMaterials && player instanceof ServerPlayerEntity) {
                        ImprovementCraftCriterion.trigger((ServerPlayerEntity)player, itemStack, upgradedStack, this.getKey(), slot, "shield/banner", 0, null, -1);
                    }
                }
            });
        }
        return upgradedStack;
    }

    @Override
    public boolean checkCapabilities(ItemStack targetStack, ItemStack[] materials, int[] availableCapabilities) {
        return true;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        return 0;
    }

    @Override
    public SchemaType getType() {
        return SchemaType.improvement;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        return new OutcomePreview[0];
    }
}

