/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;
import se.mickelus.tetra.module.ItemEffect;

public class GuiSlotEffect
extends GuiElement {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/toolbelt-inventory.png");
    String tooltip;

    public GuiSlotEffect(int x, int y, SlotType slotType, ItemEffect effect) {
        super(x, y, 8, 8);
        this.tooltip = I18n.func_135052_a((String)String.format("tetra.toolbelt.effect.tooltip.%s.%s", slotType.toString(), effect.toString()), (Object[])new Object[0]);
        switch (effect) {
            case quickAccess: {
                this.addChild((GuiElement)new GuiTexture(0, 0, 8, 8, 0, 64, texture).setColor(0xBBBBBB));
                break;
            }
            case cellSocket: {
                this.addChild((GuiElement)new GuiTexture(0, 0, 8, 8, 8, 64, texture).setColor(0xBBBBBB));
                break;
            }
            default: {
                this.addChild((GuiElement)new GuiString(0, 0, "?"));
            }
        }
    }

    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        super.calculateFocusState(refX, refY, mouseX, mouseY);
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return Collections.singletonList(this.tooltip);
        }
        return super.getTooltipLines();
    }

    public static Collection<GuiSlotEffect> getEffectsForSlot(SlotType slotType, Collection<ItemEffect> slotEffects) {
        int offset = 4 - slotEffects.size() * 4;
        AtomicInteger i = new AtomicInteger(0);
        return slotEffects.stream().map(effect -> new GuiSlotEffect(8 * i.getAndIncrement() + offset, 0, slotType, (ItemEffect)((Object)effect))).collect(Collectors.toList());
    }

    public static Collection<GuiElement> getEffectsForInventory(SlotType slotType, Collection<Collection<ItemEffect>> inventoryEffects) {
        AtomicInteger i = new AtomicInteger(0);
        return inventoryEffects.stream().map(slotEffects -> {
            GuiElement group = new GuiElement(i.getAndIncrement() * 17, 1, 16, 8);
            GuiSlotEffect.getEffectsForSlot(slotType, slotEffects).forEach(arg_0 -> ((GuiElement)group).addChild(arg_0));
            return group;
        }).collect(Collectors.toList());
    }
}

