/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;

public class OverlayGuiQuiverSlot
extends GuiElement {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/toolbelt-inventory.png");
    private ItemStack itemStack;
    private Minecraft mc;
    private KeyframeAnimation showAnimation;
    private FontRenderer fontRenderer;
    private GuiTexture backdrop;
    private GuiString count;
    private GuiString hoverLabel;

    public OverlayGuiQuiverSlot(int x, int y, ItemStack itemStack, int slot) {
        super(x, y, 23, 23);
        this.setAttachmentPoint(GuiAttachment.bottomRight);
        this.setAttachmentAnchor(GuiAttachment.bottomRight);
        this.itemStack = itemStack;
        this.mc = Minecraft.func_71410_x();
        if (itemStack != null) {
            this.fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.field_71466_p;
        }
        this.backdrop = new GuiTexture(0, 0, 23, 23, 32, 28, texture);
        this.addChild((GuiElement)this.backdrop);
        if (itemStack != null) {
            this.count = new GuiStringOutline(-3, 1, itemStack.func_190916_E() + "");
            this.count.setAttachmentPoint(GuiAttachment.middleLeft);
            this.count.setAttachmentAnchor(GuiAttachment.middleRight);
            this.addChild((GuiElement)this.count);
            this.count.setVisible(false);
            this.hoverLabel = new GuiString(-5, 0, itemStack.func_200301_q().func_150254_d());
            this.hoverLabel.setAttachmentPoint(GuiAttachment.middleRight);
            this.hoverLabel.setAttachmentAnchor(GuiAttachment.middleLeft);
            this.addChild((GuiElement)this.hoverLabel);
            this.hoverLabel.setVisible(false);
        }
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)(x - 2), (float)x), new Applier.TranslateY((float)(y + 2), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay(slot * 80).onStop(finished -> this.count.setVisible(true));
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.count.setVisible(false);
        this.hoverLabel.setVisible(false);
        return true;
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.opacity == 1.0f) {
            this.drawItemStack(this.itemStack, this.x + refX + 3, this.y + refY + 3);
        }
    }

    private void drawItemStack(ItemStack itemStack, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_227780_a_();
        this.mc.func_175599_af().func_180450_b(itemStack, x, y);
        this.mc.func_175599_af().func_180453_a(this.fontRenderer, itemStack, x, y, "");
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
        this.hoverLabel.setVisible(true);
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.hoverLabel.setVisible(false);
    }

    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = (mouseX -= refX + this.x) + (mouseY -= refY + this.y) >= 12 && mouseX + mouseY <= 34 && mouseX - mouseY < 10 && mouseY - mouseX < 11;
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

