/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.toolswap;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toolswap")
public class ToolSwap {
    public static final String MODID = "toolswap";
    public static final String MOD_NAME = "Automatic Tool Swap";
    public static final Logger LOGGER = LogManager.getLogger((String)"toolswap");
    public static final KeyBinding toggle = new KeyBinding("toolswap.key.toggle_toolswap_mode", 71, "Automatic Tool Swap");
    public static ToolSwap instance;
    private boolean isOn = true;

    public ToolSwap() {
        instance = this;
        ClientRegistry.registerKeyBinding((KeyBinding)toggle);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldTick(TickEvent.PlayerTickEvent event) {
        if (toggle.func_151468_f()) {
            TranslationTextComponent on_off;
            boolean bl = this.isOn = !this.isOn;
            if (this.isOn) {
                TranslationTextComponent on = new TranslationTextComponent("toolswap.key.toggle_toolswap_notification.state_on");
                on.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)));
                on_off = on;
            } else {
                TranslationTextComponent off = new TranslationTextComponent("toolswap.key.toggle_toolswap_notification.state_off");
                off.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_RED)));
                on_off = off;
            }
            TranslationTextComponent statusMessage = new TranslationTextComponent("toolswap.key.toggle_toolswap_notification", new Object[]{this.isOn});
            statusMessage.func_240702_b_(": ").func_230529_a_((ITextComponent)on_off);
            event.player.func_146105_b((ITextComponent)statusMessage, true);
            LOGGER.debug("Set tool swap mode to " + this.isOn);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBlockDestroy(PlayerEvent.BreakSpeed event) {
        if (this.isOn) {
            if (event.getEntity().func_130014_f_().func_82737_E() % 3L != 0L) {
                return;
            }
            BlockState state = event.getState();
            if (event.getEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                ItemStack heldItem = player.func_184614_ca();
                if (!player.func_213453_ef()) {
                    ItemStack axe = null;
                    ItemStack pickaxe = null;
                    ItemStack shovel = null;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack.getToolTypes().contains(ToolType.AXE)) {
                            axe = stack;
                            continue;
                        }
                        if (stack.getToolTypes().contains(ToolType.PICKAXE)) {
                            pickaxe = stack;
                            continue;
                        }
                        if (!stack.getToolTypes().contains(ToolType.SHOVEL)) continue;
                        shovel = stack;
                    }
                    Material material = state.func_185904_a();
                    if ((material == Material.field_151575_d || material == Material.field_215713_z || material == Material.field_151572_C) && axe != null) {
                        if (!heldItem.getToolTypes().contains(ToolType.AXE)) {
                            player.field_71071_by.field_70461_c = player.field_71071_by.func_184429_b(axe);
                        }
                    } else if ((material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g) && pickaxe != null) {
                        if (!heldItem.getToolTypes().contains(ToolType.PICKAXE)) {
                            player.field_71071_by.field_70461_c = player.field_71071_by.func_184429_b(pickaxe);
                        }
                    } else if (!(state.func_177230_c() != Blocks.field_196658_i && material != Material.field_151578_c && material != Material.field_151571_B && material != Material.field_151595_p && material != Material.field_151597_y && material != Material.field_151596_z || shovel == null || heldItem.getToolTypes().contains(ToolType.SHOVEL))) {
                        player.field_71071_by.field_70461_c = player.field_71071_by.func_184429_b(shovel);
                    }
                }
            }
        }
    }
}

