/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.torched.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.torched.common.Torched;
import me.ichun.mods.torched.common.entity.EntityTorch;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTorchFirework
extends Entity {
    private static final DataParameter<Integer> TORCHES = EntityDataManager.func_187226_a(EntityTorchFirework.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GUNPOWDER = EntityDataManager.func_187226_a(EntityTorchFirework.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ACTIVE = EntityDataManager.func_187226_a(EntityTorchFirework.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SPLIT_COUNT = EntityDataManager.func_187226_a(EntityTorchFirework.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ROCKET = EntityDataManager.func_187226_a(EntityTorchFirework.class, (DataSerializer)DataSerializers.field_187198_h);
    public EntityLivingBase initiator = null;
    public int age = 0;
    public int gunpowderCount = 0;
    public boolean activating = false;
    public boolean isSplit;
    public float fuel;
    public int xOrigin;
    public int zOrigin;
    public int prevTorches;

    public EntityTorchFirework(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
        this.fuel = 0.0f;
        this.prevTorches = 1;
        this.field_70125_A = -90.0f;
        this.field_70127_C = -90.0f;
    }

    public EntityTorchFirework(World world, int i, int j, int k, boolean isMax) {
        this(world);
        this.func_70012_b((double)i + 0.5, (double)j + 1.001, (double)k + 0.5, 0.0f, -90.0f);
        this.field_70177_z = (float)this.field_70146_Z.nextInt(4) * 90.0f;
        if (isMax) {
            this.addTorches(511);
            this.addGP(511);
        }
    }

    public EntityTorchFirework(World world, EntityLivingBase living) {
        this(world);
        this.initiator = living;
        this.setActive(true);
        this.addTorches(7);
        this.addGP(-1);
        this.activating = true;
        this.gunpowderCount = 2;
        this.fuel = (float)this.gunpowderCount * 80.0f;
        this.setRocket(true);
        this.func_70012_b(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
        this.field_70163_u -= 0.4600000014901161;
        switch (ItemHandler.getHandSide((EntityLivingBase)living, (ItemStack)ItemHandler.getUsableDualHandedItem((EntityLivingBase)living))) {
            case RIGHT: {
                this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                break;
            }
            case LEFT: {
                this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            }
        }
        this.func_70105_a(0.9f, 0.9f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, 2.0f, 5.0f);
        this.prevTorches = 8;
    }

    public EntityTorchFirework(World world, double i, double j, double k, float yaw, int torchCount, int gunPowder, EntityTorchFirework firework) {
        this(world);
        this.func_70012_b(i, j, k, yaw, -88.0f);
        this.setActive(true);
        this.addGP(-1);
        this.initiator = firework.initiator;
        this.activating = true;
        this.addTorches(torchCount - 1);
        this.gunpowderCount = gunPowder + 1;
        this.fuel = (float)this.gunpowderCount * 40.0f * (float)Math.pow((float)firework.gunpowderCount / ((float)firework.getTorches() / 3.75f), 2.0);
        double moX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double moZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double moY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading(moX, moY, moZ, (float)Math.sqrt(firework.field_70159_w * firework.field_70159_w + firework.field_70181_x * firework.field_70181_x + firework.field_70179_y * firework.field_70179_y), 0.0f);
        this.field_70181_x = firework.field_70181_x * 0.9;
    }

    public void setThrowableHeading(double par1, double par3, double par5, float par7, float par8) {
        float var9 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)var9;
        par3 /= (double)var9;
        par5 /= (double)var9;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float var10 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return par1 < 4096.0;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TORCHES, (Object)1);
        this.func_184212_Q().func_187214_a(GUNPOWDER, (Object)1);
        this.func_184212_Q().func_187214_a(IS_ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(SPLIT_COUNT, (Object)0);
        this.func_184212_Q().func_187214_a(IS_ROCKET, (Object)false);
    }

    public int getTorches() {
        return (Integer)this.func_184212_Q().func_187225_a(TORCHES);
    }

    public void addTorches(int i) {
        this.func_184212_Q().func_187227_b(TORCHES, (Object)(this.getTorches() + i));
    }

    public int getGP() {
        return (Integer)this.func_184212_Q().func_187225_a(GUNPOWDER);
    }

    public void addGP(int i) {
        this.func_184212_Q().func_187227_b(GUNPOWDER, (Object)(this.getGP() + i));
    }

    public boolean getActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ACTIVE);
    }

    public void setActive(boolean flag) {
        this.func_184212_Q().func_187227_b(IS_ACTIVE, (Object)flag);
    }

    public int getSplits() {
        return (Integer)this.func_184212_Q().func_187225_a(SPLIT_COUNT);
    }

    public void addSplit() {
        this.func_184212_Q().func_187227_b(SPLIT_COUNT, (Object)(this.getSplits() + 1));
    }

    public void setSplits(int i) {
        this.func_184212_Q().func_187227_b(SPLIT_COUNT, (Object)i);
    }

    public boolean getRocket() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ROCKET);
    }

    public void setRocket(boolean flag) {
        this.func_184212_Q().func_187227_b(IS_ROCKET, (Object)flag);
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.age == 0) {
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        ++this.age;
        if (this.activating || this.getActive() || this.func_70027_ad()) {
            if (this.getGP() <= 0) {
                this.field_70163_u += (double)0.4f;
                Torched.proxy.spawnTorchFlame(this);
                this.field_70163_u -= (double)0.4f;
                if (!this.getRocket()) {
                    this.field_70159_w *= 1.15;
                    this.field_70179_y *= 1.15;
                    this.field_70181_x += this.isSplit ? -0.01 : 0.04;
                }
                boolean forceBlow = false;
                if (Math.sqrt(this.field_70159_w * this.field_70159_w) > 5.0) {
                    forceBlow = true;
                }
                if (Math.sqrt(this.field_70179_y * this.field_70179_y) > 5.0) {
                    forceBlow = true;
                }
                if (this.field_70124_G && this.field_70170_p.field_72995_K) {
                    this.field_70181_x = 0.01;
                }
                if (this.getRocket()) {
                    Vec3d var17 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    Vec3d var3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                    RayTraceResult mop = this.field_70170_p.func_147447_a(var17, var3, false, true, false);
                    var17 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    var3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                    if (mop != null) {
                        var3 = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                    }
                    Entity collidedEnt = null;
                    List var6 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                    double var7 = 0.0;
                    for (int var9 = 0; var9 < var6.size(); ++var9) {
                        double var14;
                        Entity var10 = (Entity)var6.get(var9);
                        if (var10 instanceof EntityTorch || var10 instanceof EntityTorchFirework || !var10.func_70067_L() || var10 == this.initiator && this.age < 3) continue;
                        float var11 = 0.3f;
                        AxisAlignedBB var12 = var10.func_174813_aQ().func_72314_b((double)var11, (double)var11, (double)var11);
                        RayTraceResult var13 = var12.func_72327_a(var17, var3);
                        if (var13 == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                        collidedEnt = var10;
                        var7 = var14;
                    }
                    if (mop != null || collidedEnt != null) {
                        if (collidedEnt != null) {
                            DamageSource var21 = this.initiator == null ? new EntityDamageSourceIndirect("rptRand", (Entity)this, (Entity)this).func_76349_b() : (collidedEnt == this.initiator ? new EntityDamageSourceIndirect("rptSelf", (Entity)this, (Entity)this.initiator).func_76349_b() : new EntityDamageSourceIndirect("rpt", (Entity)this, (Entity)this.initiator).func_76349_b());
                            collidedEnt.func_70097_a(var21, 3.0f);
                        }
                        if (mop != null) {
                            this.field_70165_t = mop.field_72307_f.field_72450_a - this.field_70159_w * 1.05;
                            this.field_70163_u = mop.field_72307_f.field_72448_b - this.field_70181_x * 1.05;
                            this.field_70161_v = mop.field_72307_f.field_72449_c - this.field_70179_y * 1.05;
                        }
                        forceBlow = true;
                    }
                    this.field_70165_t += this.field_70159_w;
                    this.field_70163_u += this.field_70181_x;
                    this.field_70161_v += this.field_70179_y;
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                } else {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.fuel -= (float)this.getTorches();
                if (!this.field_70170_p.field_72995_K && (this.fuel <= 0.0f || this.isSplit && this.field_70181_x < -0.1 || forceBlow) && !this.field_70128_L) {
                    this.field_70170_p.func_72876_a((Entity)this.initiator, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRocket() ? 2.0f : (this.gunpowderCount < 5 ? 0.5f : 3.5f), false);
                    if (this.getSplits() > 0) {
                        int torch = (int)Math.floor((float)this.getTorches() / ((float)this.getSplits() + 1.0f));
                        int gunPowder = (int)Math.ceil((float)this.gunpowderCount / ((float)this.getSplits() + 1.0f));
                        float splits = this.getSplits() + 1;
                        for (int i = 0; i <= this.getSplits() && i < this.getTorches(); ++i) {
                            this.field_70170_p.func_72838_d((Entity)new EntityTorchFirework(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)0.2f * (double)((float)this.getTorches() / 96.0f), this.field_70161_v, (float)i * 360.0f / splits, torch, gunPowder, this));
                        }
                    } else {
                        for (int i = 0; i < this.getTorches(); ++i) {
                            this.field_70177_z = this.field_70170_p.field_73012_v.nextFloat() * 360.0f;
                            this.field_70125_A = this.field_70170_p.field_73012_v.nextFloat() * -85.0f - 5.0f;
                            this.field_70170_p.func_72838_d((Entity)new EntityTorch(this.field_70170_p, this, this.initiator));
                        }
                    }
                    this.func_70106_y();
                    return;
                }
                float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            } else if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() % 2L == 0L && this.activating) {
                int minus = (int)Math.ceil(this.getGP() / 100 + 1);
                this.addGP(-minus);
                this.gunpowderCount += minus;
                if (this.getGP() <= 0) {
                    this.setActive(true);
                    EntityHelper.playSoundAtEntity((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
                    this.fuel = (float)this.gunpowderCount * 140.0f;
                }
            }
            if (this.func_70027_ad()) {
                this.func_70066_B();
                this.activating = true;
                this.gunpowderCount = this.getGP();
                this.fuel = (float)this.gunpowderCount * 140.0f;
                this.addGP(-this.getGP());
                this.setActive(true);
                EntityHelper.playSoundAtEntity((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
            }
        } else if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() % 2L == 0L) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.0, 0.2, 0.0));
            for (int i = 0; i < list.size(); ++i) {
                EntityItem item;
                Entity ent = (Entity)list.get(i);
                if (!(ent instanceof EntityItem) || (item = (EntityItem)ent).func_92059_d() == null) continue;
                if (item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa)) {
                    if (this.getTorches() + item.func_92059_d().field_77994_a <= 512) {
                        this.addTorches(item.func_92059_d().field_77994_a);
                        item.func_70106_y();
                        continue;
                    }
                    if (this.getTorches() >= 512) continue;
                    this.addTorches(this.getTorches() + item.func_92059_d().field_77994_a - 512);
                    item.func_92059_d().field_77994_a -= this.getTorches() + item.func_92059_d().field_77994_a - 512;
                    continue;
                }
                if (item.func_92059_d().func_77973_b() != Items.field_151016_H) continue;
                if (this.getGP() + item.func_92059_d().field_77994_a <= 512) {
                    this.addGP(item.func_92059_d().field_77994_a);
                    item.func_70106_y();
                    continue;
                }
                if (this.getGP() >= 512) continue;
                this.addGP(this.getGP() + item.func_92059_d().field_77994_a - 512);
                item.func_92059_d().field_77994_a = this.getGP() + item.func_92059_d().field_77994_a - 512;
            }
            if (this.field_70170_p.func_180495_p(new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v))).func_177230_c() == Blocks.field_150480_ab) {
                this.func_70015_d(8);
            } else if (this.field_70170_p.func_175640_z(new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v))) || this.field_70170_p.func_175640_z(new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) - 1, (int)Math.floor(this.field_70161_v)))) {
                this.func_70066_B();
                this.activating = true;
                this.gunpowderCount = this.getGP();
                this.fuel = (float)this.gunpowderCount * 140.0f;
                this.addGP(-this.getGP());
                this.setActive(true);
                EntityHelper.playSoundAtEntity((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
            } else if (!this.field_70170_p.isSideSolid(new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v)), EnumFacing.func_82600_a((int)1), true)) {
                this.func_70097_a(DamageSource.field_76377_j, 1.0f);
            }
        } else {
            this.field_70125_A = -90.0f;
            this.field_70127_C = -90.0f;
        }
        if (this.prevTorches != this.getTorches()) {
            this.prevTorches = this.getTorches();
            this.func_70105_a(1.0f, 1.0f + (float)this.getTorches() / 192.0f);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        ItemStack is;
        if (!this.field_70170_p.field_72995_K && !this.activating && (is = player.func_184586_b(hand)) != null) {
            if (is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && this.getTorches() < 512) {
                this.addTorches(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                player.func_184609_a(hand);
                return true;
            }
            if (is.func_77973_b() == Items.field_151016_H && this.getGP() < 512) {
                this.addGP(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                player.func_184609_a(hand);
                return true;
            }
            if (is.func_77973_b() == Items.field_151033_d) {
                this.activating = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_77964_b(is.func_77952_i() + 1);
                }
                this.initiator = player;
                player.func_184609_a(hand);
                return true;
            }
            if (is.func_77973_b() == Items.field_151074_bl && this.getSplits() < 16) {
                this.addSplit();
                if (!player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                player.func_184609_a(hand);
                return true;
            }
        }
        if (this.field_70170_p.field_72995_K && player.func_184586_b(hand) != null && (player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || player.func_184586_b(hand).func_77973_b() == Items.field_151016_H || player.func_184586_b(hand).func_77973_b() == Items.field_151033_d || player.func_184586_b(hand).func_77973_b() == Items.field_151074_bl)) {
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float i) {
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            this.func_70015_d(8);
            return true;
        }
        if (i > 0.0f && !this.getActive()) {
            if (!this.field_70170_p.field_72995_K) {
                int count;
                while (this.getTorches() > 0) {
                    count = this.getTorches() > 64 ? 64 : this.getTorches();
                    this.func_70099_a(new ItemStack(Blocks.field_150478_aa, count), 0.5f);
                    this.addTorches(-count);
                }
                while (this.getGP() > 0) {
                    count = this.getGP() > 64 ? 64 : this.getGP();
                    this.func_70099_a(new ItemStack(Items.field_151016_H, count), 0.5f);
                    this.addGP(-count);
                }
                for (int ij = 0; ij < this.getSplits(); ++ij) {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl, 1), 0.5f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(Torched.itemTorchFirework, 1);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.age = tag.func_74762_e("age");
        this.addTorches(tag.func_74762_e("torchCount") - 1);
        this.addGP(tag.func_74762_e("gpCount") - 1);
        this.setActive(tag.func_74767_n("active"));
        this.activating = tag.func_74767_n("activating");
        this.gunpowderCount = tag.func_74762_e("gunpowderCount");
        this.fuel = tag.func_74760_g("fuel");
        this.setSplits(tag.func_74762_e("splits"));
        this.isSplit = tag.func_74767_n("isSplit");
        this.xOrigin = tag.func_74762_e("xOrigin");
        this.zOrigin = tag.func_74762_e("zOrigin");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("age", this.age);
        tag.func_74768_a("torchCount", this.getTorches());
        tag.func_74768_a("gpCount", this.getGP());
        tag.func_74757_a("active", this.getActive());
        tag.func_74757_a("activating", this.activating);
        tag.func_74768_a("gunpowderCount", this.gunpowderCount);
        tag.func_74776_a("fuel", this.fuel);
        tag.func_74768_a("splits", this.getSplits());
        tag.func_74757_a("isSplit", this.isSplit);
        tag.func_74768_a("xOrigin", this.xOrigin);
        tag.func_74768_a("zOrigin", this.zOrigin);
    }
}

