/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.torched.common.entity;

import java.util.List;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import me.ichun.mods.torched.common.Torched;
import me.ichun.mods.torched.common.entity.EntityTorch;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityTorchFirework
extends Entity {
    private static final DataParameter<Integer> TORCHES = EntityDataManager.func_187226_a(EntityTorchFirework.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GUNPOWDER = EntityDataManager.func_187226_a(EntityTorchFirework.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ACTIVE = EntityDataManager.func_187226_a(EntityTorchFirework.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SPLIT_COUNT = EntityDataManager.func_187226_a(EntityTorchFirework.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ROCKET = EntityDataManager.func_187226_a(EntityTorchFirework.class, (IDataSerializer)DataSerializers.field_187198_h);
    public LivingEntity initiator = null;
    public int age = 0;
    public int gunpowderCount = 0;
    public boolean activating = false;
    public boolean isSplit;
    public float fuel = 0.0f;
    public int xOrigin;
    public int zOrigin;
    public int prevTorches = 1;
    public EntitySize currentSize;

    public EntityTorchFirework(EntityType<?> type, World par1World) {
        super(type, par1World);
        this.field_70125_A = -90.0f;
        this.field_70127_C = -90.0f;
        this.currentSize = type.func_220334_j();
    }

    public EntityTorchFirework placed(int i, int j, int k, boolean isMax) {
        this.func_70012_b((double)i + 0.5, (double)j + 1.001, (double)k + 0.5, (float)this.field_70146_Z.nextInt(4) * 90.0f, 90.0f);
        if (isMax) {
            this.addTorches(511);
            this.addGP(511);
        }
        return this;
    }

    public EntityTorchFirework shot(LivingEntity living) {
        this.initiator = living;
        this.setActive(true);
        this.addTorches(7);
        this.addGP(-1);
        this.activating = true;
        this.gunpowderCount = 2;
        this.fuel = (float)this.gunpowderCount * 80.0f;
        this.setRocket(true);
        this.func_70012_b(living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e() - 0.46, living.func_226281_cx_(), living.field_70177_z, living.field_70125_A);
        double pX = this.func_226277_ct_();
        double pZ = this.func_226281_cx_();
        switch (DualHandedItem.getHandSide((LivingEntity)living, (ItemStack)DualHandedItem.getUsableDualHandedItem((LivingEntity)living))) {
            case RIGHT: {
                pX -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                pZ -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                break;
            }
            case LEFT: {
                pX += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
                pZ += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            }
        }
        this.currentSize = EntitySize.func_220314_b((float)0.9f, (float)0.9f);
        this.func_213323_x_();
        this.func_70107_b(pX, this.func_226278_cu_(), pZ);
        this.setThrowableHeading(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), 2.0f, 5.0f);
        this.prevTorches = 8;
        return this;
    }

    public EntityTorchFirework fromExplosion(double i, double j, double k, float yaw, int torchCount, int gunPowder, EntityTorchFirework firework) {
        this.func_70012_b(i, j, k, yaw, -88.0f);
        this.setActive(true);
        this.addGP(-1);
        this.initiator = firework.initiator;
        this.activating = true;
        this.addTorches(torchCount - 1);
        this.gunpowderCount = gunPowder + 1;
        this.fuel = (float)this.gunpowderCount * 40.0f * (float)Math.pow((float)firework.gunpowderCount / ((float)firework.getTorches() / 3.75f), 2.0);
        double moX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double moZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double moY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        Vector3d fMo = firework.func_213322_ci();
        this.setThrowableHeading(moX, moY, moZ, (float)Math.sqrt(fMo.field_72450_a * fMo.field_72450_a + fMo.field_72448_b * fMo.field_72448_b + fMo.field_72449_c * fMo.field_72449_c), 0.0f);
        this.func_213293_j(this.func_213322_ci().field_72450_a, fMo.field_72448_b * 0.9, this.func_213322_ci().field_72449_c);
        return this;
    }

    public void setThrowableHeading(double par1, double par3, double par5, float par7, float par8) {
        float var9 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)var9;
        par3 /= (double)var9;
        par5 /= (double)var9;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.func_213293_j(par1 *= (double)par7, par3 *= (double)par7, par5 *= (double)par7);
        float var10 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var10) * 180.0 / Math.PI);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.currentSize;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double par1) {
        return par1 < 4096.0;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TORCHES, (Object)1);
        this.func_184212_Q().func_187214_a(GUNPOWDER, (Object)1);
        this.func_184212_Q().func_187214_a(IS_ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(SPLIT_COUNT, (Object)0);
        this.func_184212_Q().func_187214_a(IS_ROCKET, (Object)false);
    }

    public int getTorches() {
        return (Integer)this.func_184212_Q().func_187225_a(TORCHES);
    }

    public void addTorches(int i) {
        this.func_184212_Q().func_187227_b(TORCHES, (Object)(this.getTorches() + i));
    }

    public int getGP() {
        return (Integer)this.func_184212_Q().func_187225_a(GUNPOWDER);
    }

    public void addGP(int i) {
        this.func_184212_Q().func_187227_b(GUNPOWDER, (Object)(this.getGP() + i));
    }

    public boolean getActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ACTIVE);
    }

    public void setActive(boolean flag) {
        this.func_184212_Q().func_187227_b(IS_ACTIVE, (Object)flag);
    }

    public int getSplits() {
        return (Integer)this.func_184212_Q().func_187225_a(SPLIT_COUNT);
    }

    public void addSplit() {
        this.func_184212_Q().func_187227_b(SPLIT_COUNT, (Object)(this.getSplits() + 1));
    }

    public void setSplits(int i) {
        this.func_184212_Q().func_187227_b(SPLIT_COUNT, (Object)i);
    }

    public boolean getRocket() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ROCKET);
    }

    public void setRocket(boolean flag) {
        this.func_184212_Q().func_187227_b(IS_ROCKET, (Object)flag);
    }

    public void func_70071_h_() {
        if (!this.func_70089_S()) {
            return;
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        super.func_70071_h_();
        if (this.age == 0) {
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        ++this.age;
        if (this.activating || this.getActive() || this.func_70027_ad()) {
            if (this.getGP() <= 0) {
                boolean forceBlow;
                Vector3d mo;
                if (this.field_70170_p.field_72995_K) {
                    this.spawnParticle();
                }
                if (!this.getRocket()) {
                    mo = this.func_213322_ci();
                    this.func_213293_j(mo.field_72450_a * 1.15, mo.field_72448_b + (this.isSplit ? -0.01 : 0.04), mo.field_72449_c * 1.15);
                }
                mo = this.func_213322_ci();
                boolean bl = forceBlow = Math.abs(mo.field_72450_a) > 5.0 || Math.abs(mo.field_72449_c) > 5.0;
                if (this.field_70124_G && this.field_70170_p.field_72995_K) {
                    this.func_213293_j(this.func_213322_ci().field_72450_a, 0.01, this.func_213322_ci().field_72449_c);
                }
                if (this.getRocket()) {
                    RayTraceResult result = EntityHelper.rayTrace((World)this.field_70170_p, (Vector3d)this.func_213303_ch(), (Vector3d)this.func_213303_ch().func_178787_e(this.func_213322_ci()), (Entity)this, (boolean)true, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, b -> true, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE, e -> !(e instanceof EntityTorch) && !(e instanceof EntityTorchFirework) && (this.age >= 4 || e != this.initiator));
                    if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                            Entity ent = ((EntityRayTraceResult)result).func_216348_a();
                            DamageSource var21 = this.initiator == null ? new IndirectEntityDamageSource("rptRand", (Entity)this, (Entity)this).func_76349_b() : (ent == this.initiator ? new IndirectEntityDamageSource("rptSelf", (Entity)this, (Entity)this.initiator).func_76349_b() : new IndirectEntityDamageSource("rpt", (Entity)this, (Entity)this.initiator).func_76349_b());
                            ent.func_70097_a(var21, 3.0f);
                        } else {
                            Vector3d hitVec = result.func_216347_e();
                            mo = this.func_213322_ci();
                            this.func_70107_b(hitVec.field_72450_a - mo.field_72450_a * 1.05, hitVec.field_72448_b - mo.field_72448_b * 1.05, hitVec.field_72449_c - mo.field_72449_c * 1.05);
                        }
                        forceBlow = true;
                    }
                    mo = this.func_213322_ci();
                    this.func_70107_b(this.func_226277_ct_() + mo.field_72450_a, this.func_226278_cu_() + mo.field_72448_b, this.func_226281_cx_() + mo.field_72449_c);
                } else {
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                }
                mo = this.func_213322_ci();
                this.field_70177_z = (float)(Math.atan2(mo.field_72450_a, mo.field_72449_c) * 180.0 / Math.PI);
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.fuel -= (float)this.getTorches();
                if (!this.field_70170_p.field_72995_K && (this.fuel <= 0.0f || this.isSplit && mo.field_72448_b < -0.1 || forceBlow) && this.func_70089_S()) {
                    this.field_70170_p.func_217385_a((Entity)this.initiator, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getRocket() ? 2.0f : (this.gunpowderCount < 5 ? 0.5f : 3.5f), Explosion.Mode.NONE);
                    if (this.getSplits() > 0) {
                        int torch = (int)Math.floor((float)this.getTorches() / ((float)this.getSplits() + 1.0f));
                        int gunPowder = (int)Math.ceil((float)this.gunpowderCount / ((float)this.getSplits() + 1.0f));
                        float splits = this.getSplits() + 1;
                        for (int i = 0; i <= this.getSplits() && i < this.getTorches(); ++i) {
                            this.field_70170_p.func_217376_c((Entity)new EntityTorchFirework((EntityType)Torched.EntityTypes.TORCH_FIREWORK.get(), this.field_70170_p).fromExplosion(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.2f * (double)((float)this.getTorches() / 96.0f), this.func_226281_cx_(), (float)i * 360.0f / splits, torch, gunPowder, this));
                        }
                    } else {
                        for (int i = 0; i < this.getTorches(); ++i) {
                            this.field_70177_z = this.field_70170_p.field_73012_v.nextFloat() * 360.0f;
                            this.field_70125_A = this.field_70170_p.field_73012_v.nextFloat() * -85.0f - 5.0f;
                            this.field_70170_p.func_217376_c((Entity)new EntityTorch((EntityType)Torched.EntityTypes.TORCH.get(), this.field_70170_p).setFirework(this, this.initiator));
                        }
                    }
                    this.func_70106_y();
                    return;
                }
                mo = this.func_213322_ci();
                this.field_70177_z = (float)(Math.atan2(mo.field_72450_a, mo.field_72449_c) * 180.0 / Math.PI);
                this.field_70125_A = (float)(Math.atan2(mo.field_72448_b, MathHelper.func_76133_a((double)(mo.field_72450_a * mo.field_72450_a + mo.field_72449_c * mo.field_72449_c))) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            } else if (!this.field_70170_p.field_72995_K && (long)this.field_70173_aa % 2L == 0L && this.activating) {
                int minus = (int)Math.ceil((float)this.getGP() / 100.0f + 1.0f);
                this.addGP(-minus);
                this.gunpowderCount += minus;
                if (this.getGP() <= 0) {
                    this.setActive(true);
                    EntityHelper.playSound((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
                    this.fuel = (float)this.gunpowderCount * 140.0f;
                }
            }
            if (this.func_70027_ad()) {
                this.func_70066_B();
                this.activating = true;
                this.gunpowderCount = this.getGP();
                this.fuel = (float)this.gunpowderCount * 140.0f;
                this.addGP(-this.getGP());
                this.setActive(true);
                EntityHelper.playSound((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
            }
        } else if (!this.field_70170_p.field_72995_K && (long)this.field_70173_aa % 2L == 0L) {
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.0, 0.2, 0.0), e -> e instanceof ItemEntity);
            for (int i = 0; i < list.size(); ++i) {
                Entity ent = (Entity)list.get(i);
                ItemEntity item = (ItemEntity)ent;
                item.func_92059_d();
                if (item.func_92059_d().func_77973_b() == Blocks.field_150478_aa.func_199767_j()) {
                    if (this.getTorches() + item.func_92059_d().func_190916_E() <= 512) {
                        this.addTorches(item.func_92059_d().func_190916_E());
                        item.func_70106_y();
                        continue;
                    }
                    if (this.getTorches() >= 512) continue;
                    this.addTorches(this.getTorches() + item.func_92059_d().func_190916_E() - 512);
                    item.func_92059_d().func_190918_g(this.getTorches() + item.func_92059_d().func_190916_E() - 512);
                    continue;
                }
                if (item.func_92059_d().func_77973_b() != Items.field_151016_H) continue;
                if (this.getGP() + item.func_92059_d().func_190916_E() <= 512) {
                    this.addGP(item.func_92059_d().func_190916_E());
                    item.func_70106_y();
                    continue;
                }
                if (this.getGP() >= 512) continue;
                this.addGP(this.getGP() + item.func_92059_d().func_190916_E() - 512);
                item.func_92059_d().func_190918_g(this.getGP() + item.func_92059_d().func_190916_E() - 512);
            }
            BlockPos thisPos = new BlockPos(this.func_213303_ch());
            if (this.field_70170_p.func_180495_p(thisPos).func_177230_c() == Blocks.field_150480_ab) {
                this.func_70015_d(8);
            } else if (this.field_70170_p.func_175640_z(thisPos) || this.field_70170_p.func_175640_z(new BlockPos((Vector3i)thisPos.func_177982_a(0, -1, 0)))) {
                this.func_70066_B();
                this.activating = true;
                this.gunpowderCount = this.getGP();
                this.fuel = (float)this.gunpowderCount * 140.0f;
                this.addGP(-this.getGP());
                this.setActive(true);
                EntityHelper.playSound((Entity)this, (SoundEvent)SoundEvents.field_187631_bo, (SoundCategory)SoundCategory.NEUTRAL, (float)3.0f, (float)1.0f);
            } else if (!this.field_70170_p.func_180495_p(thisPos.func_177982_a(0, -1, 0)).func_224755_d((IBlockReader)this.field_70170_p, thisPos.func_177982_a(0, -1, 0), Direction.UP)) {
                this.func_70097_a(DamageSource.field_76377_j, 1.0f);
            }
        } else {
            this.field_70125_A = 90.0f;
            this.field_70127_C = 90.0f;
        }
        if (this.prevTorches != this.getTorches()) {
            this.prevTorches = this.getTorches();
            this.currentSize = EntitySize.func_220314_b((float)1.0f, (float)(1.0f + (float)this.getTorches() / 192.0f));
            this.func_213323_x_();
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticle() {
        Vector3d mo = this.func_213322_ci();
        double particleSpeed = 0.75;
        float scale = 1.0f + (this.getRocket() ? 1.0f : (float)this.getTorches() / 96.0f);
        Particle particle = Minecraft.func_71410_x().field_71438_f.func_195471_b((IParticleData)Torched.Particles.FLAME.get(), true, this.func_226277_ct_() - mo.field_72450_a * 0.3, this.func_226278_cu_() - mo.field_72448_b * 0.3 + 0.4, this.func_226281_cx_() - mo.field_72449_c * 0.3, mo.field_72450_a * particleSpeed, mo.field_72448_b * particleSpeed, mo.field_72449_c * particleSpeed);
        if (particle != null) {
            particle.func_70541_f(scale);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && !this.activating) {
            ItemStack is = player.func_184586_b(hand);
            if (is.func_77973_b() == Blocks.field_150478_aa.func_199767_j() && this.getTorches() < 512) {
                this.addTorches(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                    if (is.func_190926_b()) {
                        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    }
                }
                player.func_184609_a(hand);
                return ActionResultType.CONSUME;
            }
            if (is.func_77973_b() == Items.field_151016_H && this.getGP() < 512) {
                this.addGP(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                    if (is.func_190926_b()) {
                        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    }
                }
                player.func_184609_a(hand);
                return ActionResultType.CONSUME;
            }
            if (is.func_77973_b() == Items.field_151033_d) {
                this.activating = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_196085_b(is.func_77952_i() + 1);
                }
                this.initiator = player;
                player.func_184609_a(hand);
                return ActionResultType.CONSUME;
            }
            if (is.func_77973_b() == Items.field_151074_bl && this.getSplits() < 16) {
                this.addSplit();
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                    if (is.func_190926_b()) {
                        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    }
                }
                player.func_184609_a(hand);
                return ActionResultType.CONSUME;
            }
        }
        if (this.field_70170_p.field_72995_K && (player.func_184586_b(hand).func_77973_b() == Blocks.field_150478_aa.func_199767_j() || player.func_184586_b(hand).func_77973_b() == Items.field_151016_H || player.func_184586_b(hand).func_77973_b() == Items.field_151033_d || player.func_184586_b(hand).func_77973_b() == Items.field_151074_bl)) {
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float i) {
        if (source.func_76347_k()) {
            this.func_70015_d(8);
            return true;
        }
        if (i > 0.0f && !this.getActive()) {
            if (!this.field_70170_p.field_72995_K) {
                int count;
                while (this.getTorches() > 0) {
                    count = Math.min(this.getTorches(), 64);
                    this.func_70099_a(new ItemStack((IItemProvider)Blocks.field_150478_aa, count), 0.5f);
                    this.addTorches(-count);
                }
                while (this.getGP() > 0) {
                    count = Math.min(this.getGP(), 64);
                    this.func_70099_a(new ItemStack((IItemProvider)Items.field_151016_H, count), 0.5f);
                    this.addGP(-count);
                }
                for (int ij = 0; ij < this.getSplits(); ++ij) {
                    this.func_70099_a(new ItemStack((IItemProvider)Items.field_151074_bl, 1), 0.5f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Torched.Items.TORCH_FIREWORK.get());
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.age = tag.func_74762_e("age");
        this.addTorches(tag.func_74762_e("torchCount") - 1);
        this.addGP(tag.func_74762_e("gpCount") - 1);
        this.setActive(tag.func_74767_n("active"));
        this.activating = tag.func_74767_n("activating");
        this.gunpowderCount = tag.func_74762_e("gunpowderCount");
        this.fuel = tag.func_74760_g("fuel");
        this.setSplits(tag.func_74762_e("splits"));
        this.isSplit = tag.func_74767_n("isSplit");
        this.xOrigin = tag.func_74762_e("xOrigin");
        this.zOrigin = tag.func_74762_e("zOrigin");
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a("age", this.age);
        tag.func_74768_a("torchCount", this.getTorches());
        tag.func_74768_a("gpCount", this.getGP());
        tag.func_74757_a("active", this.getActive());
        tag.func_74757_a("activating", this.activating);
        tag.func_74768_a("gunpowderCount", this.gunpowderCount);
        tag.func_74776_a("fuel", this.fuel);
        tag.func_74768_a("splits", this.getSplits());
        tag.func_74757_a("isSplit", this.isSplit);
        tag.func_74768_a("xOrigin", this.xOrigin);
        tag.func_74768_a("zOrigin", this.zOrigin);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

