/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.util;

import com._idrae.towers_of_the_wild.TowersOfTheWild;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerGrassPieces;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.IceTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.JungleTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.TowerPieces;
import com._idrae.towers_of_the_wild.world.structures.TowerStructure;
import com.mojang.serialization.Codec;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHandler {
    public static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"towers_of_the_wild");
    public static final RegistryObject<Structure<NoFeatureConfig>> TOWER = RegistryHandler.registerStructure("tower", new TowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final IStructurePieceType TOWER_PIECE = TowerPieces.Piece::new;
    public static final IStructurePieceType JUNGLE_TOWER_PIECE = JungleTowerPieces.Piece::new;
    public static final IStructurePieceType ICE_TOWER_PIECE = IceTowerPieces.Piece::new;
    public static final IStructurePieceType DERELICT_TOWER_PIECE = DerelictTowerPieces.Piece::new;
    public static final IStructurePieceType DERELICT_TOWER_GRASS_PIECE = DerelictTowerGrassPieces.Piece::new;

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, T structure) {
        Structure.field_236365_a_.put((Object)("towers_of_the_wild:" + name), structure);
        Structure.field_236385_u_.put(structure, GenerationStage.Decoration.SURFACE_STRUCTURES);
        TowersOfTheWild.LOGGER.info(name + " structure registered");
        return STRUCTURE_FEATURES.register(name, () -> structure);
    }

    public static void registerPieces() {
        RegistryHandler.registerPiece("tower", TOWER_PIECE);
        RegistryHandler.registerPiece("jungle_tower", JUNGLE_TOWER_PIECE);
        RegistryHandler.registerPiece("ice_tower", ICE_TOWER_PIECE);
        RegistryHandler.registerPiece("derelict_tower", DERELICT_TOWER_PIECE);
        RegistryHandler.registerPiece("derelict_tower_grass", DERELICT_TOWER_GRASS_PIECE);
    }

    private static void registerPiece(String key, IStructurePieceType type) {
        TowersOfTheWild.LOGGER.info(key + " structure piece registered");
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("towers_of_the_wild", key), (Object)type);
    }
}

