/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.world.structures;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class AbstractTowerPiece
extends TemplateStructurePiece {
    private static final ResourceLocation TOWER_CHEST = new ResourceLocation("towers_of_the_wild", "chests/tower_chest");
    protected final Map<ResourceLocation, BlockPos> centerTopOffsets;
    protected final ResourceLocation structurePart;
    protected final Rotation field_186169_c;

    public AbstractTowerPiece(TemplateManager templateManager, ResourceLocation structurePart, Rotation rotation, IStructurePieceType piece, Map<ResourceLocation, BlockPos> centerTopOffsets) {
        super(piece, 0);
        this.structurePart = structurePart;
        this.field_186169_c = rotation;
        this.centerTopOffsets = centerTopOffsets;
    }

    public AbstractTowerPiece(TemplateManager templateManager, IStructurePieceType structurePieceTypeIn, CompoundNBT nbt, Map<ResourceLocation, BlockPos> centerTopOffsets) {
        super(structurePieceTypeIn, nbt);
        this.structurePart = new ResourceLocation(nbt.func_74779_i("Template"));
        this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.centerTopOffsets = centerTopOffsets;
        this.func_207614_a(templateManager);
    }

    protected void func_207614_a(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.structurePart);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(this.centerTopOffsets.get(this.structurePart));
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74778_a("Template", this.structurePart.toString());
        tagCompound.func_74778_a("Rot", this.field_186169_c.name());
    }

    protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
        if ("chest".equals(function)) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
            if (tileentity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_189404_a(TOWER_CHEST, rand.nextLong());
            }
        }
    }
}

