/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.world.structures;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.util.RegistryHandler;
import com._idrae.towers_of_the_wild.world.structures.AbstractTowerPiece;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.ModList;

public class DerelictTowerGrassPieces {
    private static final ResourceLocation DERELICT_TOWER_TOP = ModList.get().isLoaded("waystones") && TowersOfTheWildConfig.waystonesCompat ? new ResourceLocation("towers_of_the_wild", "waystone_derelict_tower_top_grass") : new ResourceLocation("towers_of_the_wild", "derelict_tower_top_grass");
    private static final ResourceLocation DERELICT_TOWER_BOTTOM = new ResourceLocation("towers_of_the_wild", "derelict_tower_bottom");
    private static final Map<ResourceLocation, BlockPos> CENTER_TOP_OFFSETS = ImmutableMap.of((Object)DERELICT_TOWER_TOP, (Object)new BlockPos(6, 5, 6), (Object)DERELICT_TOWER_BOTTOM, (Object)new BlockPos(3, 31, 3));
    private static final Map<ResourceLocation, BlockPos> CORNER_RELATIVE_POSITIONS = ImmutableMap.of((Object)DERELICT_TOWER_TOP, (Object)new BlockPos(4, 0, 4), (Object)DERELICT_TOWER_BOTTOM, (Object)BlockPos.field_177992_a);

    public static void addPieces(TemplateManager templateManager, BlockPos absolutePos, Rotation rotation, List<StructurePiece> pieces, Random random, NoFeatureConfig config) {
        pieces.add((StructurePiece)new Piece(templateManager, DERELICT_TOWER_BOTTOM, absolutePos, rotation));
        pieces.add((StructurePiece)new Piece(templateManager, DERELICT_TOWER_TOP, absolutePos, rotation));
    }

    public static class Piece
    extends AbstractTowerPiece {
        public Piece(TemplateManager templateManager, ResourceLocation structurePart, BlockPos absolutePos, Rotation rotation) {
            super(templateManager, structurePart, rotation, RegistryHandler.DERELICT_TOWER_PIECE, CENTER_TOP_OFFSETS);
            BlockPos relativePos = (BlockPos)CORNER_RELATIVE_POSITIONS.get(structurePart);
            this.field_186178_c = absolutePos.func_177982_a(relativePos.func_177958_n(), relativePos.func_177956_o(), relativePos.func_177952_p());
            this.func_207614_a(templateManager);
        }

        public Piece(TemplateManager p_i50566_1_, CompoundNBT p_i50566_2_) {
            super(p_i50566_1_, RegistryHandler.DERELICT_TOWER_GRASS_PIECE, p_i50566_2_, CENTER_TOP_OFFSETS);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            if (this.structurePart.equals((Object)DERELICT_TOWER_BOTTOM)) {
                int j;
                int i;
                BlockPos blockpos1 = this.field_186178_c;
                int minHeight = Integer.MAX_VALUE;
                for (i = 0; i < 5; ++i) {
                    for (j = 0; j < 5; ++j) {
                        int height = p_230383_1_.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n() + i, blockpos1.func_177952_p() + j);
                        if (height >= minHeight) continue;
                        minHeight = height;
                    }
                }
                for (i = -1; i < 6; ++i) {
                    for (j = -1; j < 6; ++j) {
                        BlockPos grassPos = new BlockPos(blockpos1.func_177958_n() + i, minHeight - 1, blockpos1.func_177952_p() + j);
                        BlockState blockstate = p_230383_1_.func_180495_p(grassPos);
                        if (blockstate.func_177230_c() == Blocks.field_150346_d) {
                            p_230383_1_.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 3);
                        }
                        if ((i == -1 || i == 5) && (j == -1 || j == 5) || blockstate.func_177230_c() != Blocks.field_150355_j) continue;
                        p_230383_1_.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 3);
                    }
                }
                this.field_186178_c = this.field_186178_c.func_177982_a(0, minHeight - 90, 0);
            } else if (this.structurePart.equals((Object)DERELICT_TOWER_TOP)) {
                int j;
                int i;
                BlockPos blockpos1 = this.field_186178_c;
                int minHeight = Integer.MAX_VALUE;
                for (i = 0; i < 5; ++i) {
                    for (j = 0; j < 5; ++j) {
                        int height = p_230383_1_.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n() + 2 + i, blockpos1.func_177952_p() + 2 + j);
                        if (height >= minHeight) continue;
                        minHeight = height;
                    }
                }
                for (i = 0; i < 11; ++i) {
                    for (j = 0; j < 11; ++j) {
                        BlockPos grassPos = new BlockPos(blockpos1.func_177958_n() + i, minHeight - 1, blockpos1.func_177952_p() + j);
                        BlockState blockstate = p_230383_1_.func_180495_p(grassPos);
                        if (blockstate.func_177230_c() != Blocks.field_150346_d) continue;
                        p_230383_1_.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 3);
                    }
                }
                this.field_186178_c = this.field_186178_c.func_177982_a(0, minHeight - 90, 0);
            }
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }
}

