/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackRemovals;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.network.client.ParticlesPacket;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BackpackAbilities {
    public static BackpackAbilities backpackAbilities = new BackpackAbilities();
    public static BackpackRemovals backpackRemovals = new BackpackRemovals();

    public static boolean hasItemAbility(String colorName) {
        for (String valid : Reference.validWearingBackpacks) {
            if (!valid.equals(colorName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTileAbility(String colorName) {
        for (String valid : Reference.validTileBackpacks) {
            if (!valid.equals(colorName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRemoval(String colorName) {
        for (String valid : Reference.validRemovalBackpacks) {
            if (!valid.equals(colorName)) continue;
            return true;
        }
        return false;
    }

    public void executeItemAbility(EntityPlayer player, World world, ItemStack stack) {
        String color = Reference.BACKPACK_NAMES[stack.func_77960_j()];
        if (color.equals("Bat")) {
            this.itemBat(player, world, stack);
        }
        if (color.equals("Cactus")) {
            this.itemCactus(player, world, stack);
        }
        if (color.equals("Chicken")) {
            this.itemChicken(player, world, stack);
        }
        if (color.equals("Creeper")) {
            this.itemCreeper(player, world, stack);
        }
        if (color.equals("Dragon")) {
            this.itemDragon(player, world, stack);
        }
        if (color.equals("Emerald")) {
            TravelersBackpack.NETWORK.sendToAll((IMessage)new ParticlesPacket(2, player.func_145782_y()));
        }
        if (color.equals("Pig")) {
            this.itemPig(player, world, stack);
        }
        if (color.equals("Pigman")) {
            this.itemPigman(player, world, stack);
        }
        if (color.equals("Rainbow")) {
            this.itemRainbow(player, world, stack);
        }
        if (color.equals("Slime")) {
            this.itemSlime(player, world, stack);
        }
        if (color.equals("Squid")) {
            this.itemSquid(player, world, stack);
        }
        if (color.equals("Sunflower")) {
            this.itemSunflower(player, world, stack);
        }
        if (color.equals("Wolf")) {
            this.itemWolf(player, world, stack);
        }
    }

    public void executeTileAbility(EntityPlayer player, World world, TileEntityTravelersBackpack tile) {
        String color = tile.getColor();
        if (color.equals("Cactus")) {
            this.tileCactus(player, world, tile);
        }
    }

    public void executeRemoval(EntityPlayer player, World world, ItemStack stack) {
        String color = Reference.BACKPACK_NAMES[stack.func_77960_j()];
        if (color.equals("Bat")) {
            backpackRemovals.itemBat(player, world, stack);
        }
        if (color.equals("Dragon")) {
            backpackRemovals.itemDragon(player, world, stack);
        }
        if (color.equals("Pigman")) {
            backpackRemovals.itemPigman(player, world, stack);
        }
        if (color.equals("Rainbow")) {
            backpackRemovals.itemRainbow(player, world, stack);
        }
        if (color.equals("Squid")) {
            backpackRemovals.itemSquid(player, world, stack);
        }
        if (color.equals("Wolf")) {
            backpackRemovals.itemWolf(player, world, stack);
        }
    }

    private boolean isUnderRain(EntityPlayer player) {
        return (player.field_70170_p.func_175678_i(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v))) || player.field_70170_p.func_175678_i(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.field_70131_O)), MathHelper.func_76128_c((double)player.field_70161_v)))) && player.field_70170_p.func_72896_J();
    }

    public void itemBat(EntityPlayer player, World world, ItemStack stack) {
        PotionEffect effect = player.func_70660_b(MobEffects.field_76439_r);
        if (effect == null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, false, false));
        } else if (effect.func_76459_b() == 209) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, false, false));
        }
    }

    public void itemCactus(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        FluidTank leftTank = inv.getLeftTank();
        FluidTank rightTank = inv.getRightTank();
        int drops = 0;
        if (player.func_70090_H()) {
            drops += 2;
        }
        if (this.isUnderRain(player)) {
            ++drops;
        }
        FluidStack water = new FluidStack(FluidRegistry.WATER, drops);
        if (inv.getLastTime() <= 0 && drops > 0) {
            inv.setLastTime(5);
            if (leftTank.canFillFluidType(water) && !world.field_72995_K) {
                leftTank.fill(water, true);
            }
            if (rightTank.canFillFluidType(water) && !world.field_72995_K) {
                rightTank.fill(water, true);
            }
            inv.func_70296_d();
        } else {
            inv.setLastTime(inv.getLastTime() - 1);
            inv.markTimeDirty();
        }
    }

    public void itemChicken(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        int eggTime = inv.getLastTime() - 1;
        if (eggTime <= 0) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.AMBIENT, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f + 1.0f);
            if (!world.field_72995_K) {
                player.func_145779_a(Items.field_151110_aK, 1);
            }
            eggTime = (200 + 10 * world.field_73012_v.nextInt(10)) * 20;
        }
        inv.setLastTime(eggTime);
        inv.markTimeDirty();
    }

    public void itemCreeper(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        int pssstTime = inv.getLastTime();
        if (pssstTime > 0) {
            pssstTime = inv.getLastTime() - 1;
        }
        if (pssstTime <= 0 && player.func_70093_af()) {
            List entities = world.func_72839_b((Entity)player, new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0).func_72321_a(5.0, 1.0, 5.0));
            if (entities.isEmpty()) {
                --pssstTime;
                return;
            }
            for (Entity entity : entities) {
                if (!(entity instanceof EntityPlayer) || !(player.func_70032_d(entity) <= 3.0f)) continue;
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187572_ar, SoundCategory.AMBIENT, 1.2f, 0.5f);
                pssstTime = 2400;
            }
        }
        inv.setLastTime(pssstTime);
        inv.markTimeDirty();
    }

    public void itemDragon(EntityPlayer player, World world, ItemStack stack) {
        this.itemPigman(player, world, stack);
        this.itemSquid(player, world, stack);
        PotionEffect effectRegeneration = player.func_70660_b(MobEffects.field_76428_l);
        PotionEffect effectStrenght = player.func_70660_b(MobEffects.field_76420_g);
        if (effectRegeneration == null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 420, 0, false, false));
        } else if (effectRegeneration.func_76459_b() <= 210) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 420, 0, false, false));
        }
        if (effectStrenght == null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 210, 0, false, false));
        } else if (effectStrenght.func_76459_b() <= 210) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 210, 0, false, false));
        }
    }

    public void itemPig(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        int oinkTime = inv.getLastTime() - 1;
        if (oinkTime <= 0) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187697_dL, SoundCategory.AMBIENT, 0.8f, 1.0f);
            oinkTime = world.field_73012_v.nextInt(61) * 20;
        }
        inv.setLastTime(oinkTime);
        inv.markTimeDirty();
    }

    public void itemPigman(EntityPlayer player, World world, ItemStack stack) {
        PotionEffect effectFireResistance = player.func_70660_b(MobEffects.field_76426_n);
        if (effectFireResistance == null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 210, 0, false, false));
        } else if (effectFireResistance.func_76459_b() <= 210) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 210, 0, false, false));
        }
    }

    public void itemRainbow(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        if (player.func_70051_ag()) {
            TravelersBackpack.NETWORK.sendToAll((IMessage)new ParticlesPacket(0, player.func_145782_y()));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 210, 1, false, false));
        player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 210, 1, false, false));
        inv.markTimeDirty();
    }

    public void itemSlime(EntityPlayer player, World world, ItemStack stack) {
        if (player.field_70122_E) {
            if (player.field_191988_bg == 0.0f && player.field_70702_br == 0.0f && Math.abs(player.field_191988_bg) < 3.0f && Math.abs(player.field_70702_br) < 3.0f) {
                player.func_70024_g(player.field_70159_w *= 0.828, 0.0, player.field_70179_y *= 0.828);
            }
            if (player.func_70051_ag()) {
                int slimeTime;
                InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
                int n = slimeTime = inv.getLastTime() > 0 ? inv.getLastTime() - 1 : 5;
                if (slimeTime <= 0) {
                    if (!world.field_72995_K) {
                        TravelersBackpack.NETWORK.sendToAll((IMessage)new ParticlesPacket(1, player.func_145782_y()));
                    }
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187886_fs, SoundCategory.AMBIENT, 0.6f, 1.0f);
                    slimeTime = 5;
                }
                inv.setLastTime(slimeTime);
                inv.markTimeDirty();
            }
        }
    }

    public void itemSquid(EntityPlayer player, World world, ItemStack stack) {
        if (player.func_70090_H()) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 210, 0, false, false));
            this.itemBat(player, world, stack);
        } else {
            backpackRemovals.itemSquid(player, world, stack);
        }
    }

    public void itemSunflower(EntityPlayer player, World world, ItemStack stack) {
        InventoryTravelersBackpack inv = new InventoryTravelersBackpack(stack, player);
        if (inv.getLastTime() <= 0) {
            if (world.func_72935_r() && world.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + 1.0)), MathHelper.func_76128_c((double)player.field_70161_v)))) {
                player.func_71024_bL().func_75122_a(2, 0.2f);
                inv.setLastTime(2400);
            }
        } else if (inv.getLastTime() > 0) {
            inv.setLastTime(inv.getLastTime() - 1);
        }
        inv.func_70296_d();
    }

    public void itemWolf(EntityPlayer player, World world, ItemStack stack) {
        int lastCheckTime;
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        if (!world.func_72935_r() && world.getCurrentMoonPhaseFactorBody() == 1.0f) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 21, 2, false, false));
        }
        if ((lastCheckTime = inv.getLastTime() - 1) <= 0) {
            lastCheckTime = 20;
            List wolves = world.func_72872_a(EntityWolf.class, new AxisAlignedBB(player.field_70165_t - 7.0, player.field_70163_u - 7.0, player.field_70161_v - 7.0, player.field_70165_t + 7.0, player.field_70163_u + 7.0, player.field_70161_v + 7.0));
            if (wolves.isEmpty()) {
                return;
            }
            for (EntityWolf wolf : wolves) {
                if (!wolf.func_70919_bu() || wolf.func_70638_az() != player) continue;
                wolf.func_70916_h(false);
                wolf.func_70624_b(null);
                wolf.func_70604_c(null);
                Iterator i2 = wolf.field_70715_bh.field_75782_a.iterator();
                while (i2.hasNext()) {
                    ((EntityAITasks.EntityAITaskEntry)i2.next()).field_75733_a.func_75251_c();
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189111_gN, SoundCategory.HOSTILE, 0.7f, 0.5f);
                }
            }
        }
        inv.setLastTime(lastCheckTime);
        inv.markTimeDirty();
    }

    public void tileCactus(EntityPlayer player, World world, TileEntityTravelersBackpack tile) {
        if (world.func_72896_J() && world.func_175678_i(tile.func_174877_v())) {
            int dropTime = tile.getLastTime() - 1;
            if (dropTime <= 0) {
                if (tile.getLeftTank().canFillFluidType(new FluidStack(FluidRegistry.WATER, 2))) {
                    tile.getLeftTank().fill(new FluidStack(FluidRegistry.WATER, 2), true);
                }
                if (tile.getRightTank().canFillFluidType(new FluidStack(FluidRegistry.WATER, 2))) {
                    tile.getRightTank().fill(new FluidStack(FluidRegistry.WATER, 2), true);
                }
                dropTime = 5;
            }
            tile.setLastTime(dropTime);
        }
    }
}

