/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.gui.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.gui.ScreenTank;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.network.CycleToolPacket;
import com.tiviacz.travelersbackpack.network.EquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.SleepingBagPacket;
import com.tiviacz.travelersbackpack.network.UnequipBackpackPacket;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends ContainerScreen<TravelersBackpackBaseContainer> {
    public static final ResourceLocation SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack.png");
    private static final ScreenImageButton bedButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton equipButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton unequipButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton emptyTankButtonLeft = new ScreenImageButton(14, 86, 9, 9);
    private static final ScreenImageButton emptyTankButtonRight = new ScreenImageButton(225, 86, 9, 9);
    private static final ScreenImageButton disabledCraftingButton = new ScreenImageButton(225, 96, 18, 18);
    private final IInventoryTravelersBackpack inventory;
    private final byte screenID;
    private final ScreenTank tankLeft;
    private final ScreenTank tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.inventory = screenContainer.inventory;
        this.screenID = screenContainer.inventory.getScreenID();
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 207;
        this.tankLeft = new ScreenTank(this.inventory.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new ScreenTank(this.inventory.getRightTank(), 207, 7, 100, 16);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (!this.inventory.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar();
        }
        if (!this.inventory.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.renderTooltip(this.tankLeft.getTankTooltip(), mouseX, mouseY, this.font);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.renderTooltip(this.tankRight.getTankTooltip(), mouseX, mouseY, this.font);
        }
        if (this.screenID == 2 && (emptyTankButtonLeft.inButton(this, mouseX, mouseY) || emptyTankButtonRight.inButton(this, mouseX, mouseY))) {
            this.renderTooltip(I18n.func_135052_a((String)"screen.empty.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (((Boolean)TravelersBackpackConfig.COMMON.disableCrafting.get()).booleanValue() && disabledCraftingButton.inButton(this, mouseX, mouseY)) {
            this.renderTooltip(I18n.func_135052_a((String)"screen.disabled_crafting.name", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(SCREEN_TRAVELERS_BACKPACK);
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((Boolean)TravelersBackpackConfig.COMMON.disableCrafting.get()).booleanValue()) {
            disabledCraftingButton.draw(this, 77, 208);
        }
        if (this.inventory.hasTileEntity()) {
            if (bedButton.inButton(this, mouseX, mouseY)) {
                bedButton.draw(this, 20, 227);
            } else {
                bedButton.draw(this, 1, 227);
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1) {
                if (equipButton.inButton(this, mouseX, mouseY)) {
                    equipButton.draw(this, 58, 208);
                } else {
                    equipButton.draw(this, 39, 208);
                }
            }
            if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
                if (unequipButton.inButton(this, mouseX, mouseY)) {
                    unequipButton.draw(this, 58, 227);
                } else {
                    unequipButton.draw(this, 39, 227);
                }
                if (((Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get()).booleanValue()) {
                    if (emptyTankButtonLeft.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonLeft.draw(this, 29, 217);
                    } else {
                        emptyTankButtonLeft.draw(this, 10, 217);
                    }
                    if (emptyTankButtonRight.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonRight.draw(this, 29, 217);
                    } else {
                        emptyTankButtonRight.draw(this, 10, 217);
                    }
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.inventory.hasTileEntity() && bedButton.inButton(this, (int)mouseX, (int)mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SleepingBagPacket(this.inventory.getPosition()));
            return true;
        }
        if (!this.inventory.hasTileEntity() && !CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && equipButton.inButton(this, (int)mouseX, (int)mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new EquipBackpackPacket(true));
            return true;
        }
        if (!this.inventory.hasTileEntity() && CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
            if (unequipButton.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new UnequipBackpackPacket(true));
                return true;
            }
            if (!this.inventory.getLeftTank().isEmpty() && emptyTankButtonLeft.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new CycleToolPacket(1.0, 3));
            }
            if (!this.inventory.getRightTank().isEmpty() && emptyTankButtonRight.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new CycleToolPacket(2.0, 3));
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

