/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public TravelersBackpackWearableModel model = new TravelersBackpackWearableModel();

    public TravelersBackpackLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(AbstractClientPlayerEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        TravelersBackpackInventory inv;
        if (CapabilityUtils.isWearingBackpack((PlayerEntity)entityIn) && (inv = CapabilityUtils.getBackpackInv((PlayerEntity)entityIn)) != null && entityIn.func_152122_n() && !entityIn.func_82150_aj()) {
            ItemStack stack = entityIn.func_184582_a(EquipmentSlotType.CHEST);
            if (!((Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get()).booleanValue()) {
                if (stack.func_77973_b() instanceof ElytraItem) {
                    return;
                }
                this.renderLayer((PlayerEntity)entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            } else {
                this.renderLayer((PlayerEntity)entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    private void renderLayer(PlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            GlStateManager.pushMatrix();
            if (player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.22f, (float)0.0f);
            }
            ((PlayerModel)this.func_215332_c()).field_78115_e.func_78794_c(scale);
            GlStateManager.translatef((float)0.0f, (float)0.175f, (float)0.325f);
            GlStateManager.scalef((float)0.9f, (float)0.9f, (float)0.9f);
            ItemStack stack = CapabilityUtils.getWearingBackpack(player);
            this.model.func_217111_a(this.func_215332_c());
            this.func_215333_a(new ResourceLocation("travelersbackpack", "textures/model/standard.png"));
            this.model.func_78088_a(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.popMatrix();
        }
    }
}

