/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TravelersBackpackItem
extends BlockItem {
    private final Block block;

    public TravelersBackpackItem(Block block) {
        super(block, new Item.Properties().func_200916_a(Reference.TRAVELERS_BACKPACK_TAB).func_200917_a(1).setTEISR(() -> TravelersBackpackItemStackRenderer::new));
        this.block = block;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && handIn == Hand.MAIN_HAND && itemstack.func_77973_b() == this && !playerIn.func_70093_af()) {
            TravelersBackpackInventory.openGUI((ServerPlayerEntity)playerIn, playerIn.field_71071_by.func_70448_g(), (byte)1);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack;
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (context.func_221531_n() == Hand.MAIN_HAND && !player.func_70093_af()) {
            return ActionResultType.FAIL;
        }
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (!blockState.func_196953_a(new BlockItemUseContext(context))) {
            pos = pos.func_177972_a(context.func_196000_l());
        }
        if (!(stack = player.func_184586_b(context.func_221531_n())).func_190926_b() && player.func_175151_a(pos, context.func_195992_f(), stack)) {
            BlockState blockState1 = this.block.func_196258_a(new BlockItemUseContext(context));
            if (this.placeBlockAt(stack, player, world, pos, blockState1)) {
                if (stack.func_77978_p() != null) {
                    ((TravelersBackpackTileEntity)world.func_175625_s(pos)).loadAllData(stack.func_77978_p());
                }
                blockState1 = world.func_180495_p(pos);
                SoundType soundtype = blockState1.func_177230_c().getSoundType(blockState1, (IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, PlayerEntity player, World world, BlockPos pos, BlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.block) {
            TravelersBackpackItem.func_179224_a((World)world, (PlayerEntity)player, (BlockPos)pos, (ItemStack)stack);
            this.block.func_180633_a(world, pos, state, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("block.travelersbackpack.travelers_backpack", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_211708_a(TextFormatting.BLUE));
    }
}

