/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CycleToolPacket {
    private double scrollDelta;
    private int typeOfAction;

    public CycleToolPacket(double scrollDelta, int typeOfAction) {
        this.scrollDelta = scrollDelta;
        this.typeOfAction = typeOfAction;
    }

    public static CycleToolPacket decode(PacketBuffer buffer) {
        double scrollDelta = buffer.readDouble();
        int typeOfAction = buffer.readInt();
        return new CycleToolPacket(scrollDelta, typeOfAction);
    }

    public static void encode(CycleToolPacket message, PacketBuffer buffer) {
        buffer.writeDouble(message.scrollDelta);
        buffer.writeInt(message.typeOfAction);
    }

    public static void handle(CycleToolPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null && CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayerEntity)) {
                if (message.typeOfAction == 0) {
                    ServerActions.cycleTool((PlayerEntity)serverPlayerEntity, message.scrollDelta);
                } else if (message.typeOfAction == 1) {
                    ServerActions.switchHoseMode((PlayerEntity)serverPlayerEntity, message.scrollDelta);
                } else if (message.typeOfAction == 2) {
                    ServerActions.toggleHoseTank((PlayerEntity)serverPlayerEntity);
                } else if (message.typeOfAction == 3) {
                    ServerActions.emptyTank(message.scrollDelta, (PlayerEntity)serverPlayerEntity, serverPlayerEntity.field_70170_p);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

