/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class EquipBackpackPacket {
    private boolean valid;

    public EquipBackpackPacket(boolean valid) {
        this.valid = valid;
    }

    public static EquipBackpackPacket decode(PacketBuffer buffer) {
        boolean valid = buffer.readBoolean();
        return new EquipBackpackPacket(valid);
    }

    public static void encode(EquipBackpackPacket message, PacketBuffer buffer) {
        buffer.writeBoolean(message.valid);
    }

    public static void handle(EquipBackpackPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null && message.valid) {
                if (!CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayerEntity)) {
                    ServerActions.equipBackpack((PlayerEntity)serverPlayerEntity);
                } else {
                    serverPlayerEntity.func_71128_l();
                    serverPlayerEntity.func_71053_j();
                    serverPlayerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("actions.equip_backpack.otherbackpack", new Object[0]));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

