/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ScreenPacket {
    private byte type;
    private byte from;

    public ScreenPacket(byte type, byte from) {
        this.type = type;
        this.from = from;
    }

    public static ScreenPacket decode(PacketBuffer buffer) {
        byte type = buffer.readByte();
        byte from = buffer.readByte();
        return new ScreenPacket(type, from);
    }

    public static void encode(ScreenPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.type);
        buffer.writeByte((int)message.from);
    }

    public static void handle(ScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null && message.type == 1 && message.from == 0 && CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayerEntity)) {
                TravelersBackpackInventory.openGUI(serverPlayerEntity, CapabilityUtils.getWearingBackpack((PlayerEntity)serverPlayerEntity), (byte)2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

