/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.tileentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModTileEntityTypes;
import com.tiviacz.travelersbackpack.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public class TravelersBackpackTileEntity
extends TileEntity
implements IInventoryTravelersBackpack,
ITickableTileEntity,
INamedContainerProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final FluidTank leftTank;
    private final FluidTank rightTank;
    private boolean isSleepingBagDeployed;
    private int lastTime;

    public TravelersBackpackTileEntity() {
        super((TileEntityType)ModTileEntityTypes.TRAVELERS_BACKPACK.get());
        this.leftTank = new FluidTank(((Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get()).intValue());
        this.rightTank = new FluidTank(((Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get()).intValue());
        this.isSleepingBagDeployed = false;
        this.lastTime = 0;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.saveAllData(compound);
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.loadAllData(compound);
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(World world, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        Direction direction = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && world.func_175623_d(sleepingBagPos2 = (sleepingBagPos1 = pos.func_177972_a(direction)).func_177972_a(direction)) && world.func_175623_d(sleepingBagPos1) && world.func_180495_p(sleepingBagPos1.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos1.func_177977_b(), Direction.UP) && world.func_180495_p(sleepingBagPos2.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos2.func_177977_b(), Direction.UP)) {
            world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
            if (!world.field_72995_K) {
                world.func_175656_a(sleepingBagPos1, (BlockState)((BlockState)((Block)ModBlocks.SLEEPING_BAG.get()).func_176223_P().func_206870_a((IProperty)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.FOOT));
                world.func_175656_a(sleepingBagPos2, (BlockState)((BlockState)((Block)ModBlocks.SLEEPING_BAG.get()).func_176223_P().func_206870_a((IProperty)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.HEAD));
                world.func_195592_c(pos, (Block)ModBlocks.SLEEPING_BAG.get());
                world.func_195592_c(sleepingBagPos2, (Block)ModBlocks.SLEEPING_BAG.get());
            }
            this.isSleepingBagDeployed = true;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(World world) {
        Direction blockFacing = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            BlockPos sleepingBagPos1 = this.field_174879_c.func_177972_a(blockFacing);
            BlockPos sleepingBagPos2 = sleepingBagPos1.func_177972_a(blockFacing);
            if (world.func_180495_p(sleepingBagPos1).func_177230_c() == ModBlocks.SLEEPING_BAG.get() && world.func_180495_p(sleepingBagPos2).func_177230_c() == ModBlocks.SLEEPING_BAG.get()) {
                world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
                world.func_175656_a(sleepingBagPos2, Blocks.field_150350_a.func_176223_P());
                world.func_175656_a(sleepingBagPos1, Blocks.field_150350_a.func_176223_P());
                this.isSleepingBagDeployed = false;
                this.func_70296_d();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c() == ModBlocks.SLEEPING_BAG.get() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction).func_177972_a(direction)).func_177230_c() == ModBlocks.SLEEPING_BAG.get()) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public Direction getBlockDirection(TileEntity tile) {
        if (tile instanceof TravelersBackpackTileEntity) {
            if (this.field_145850_b == null || !(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof TravelersBackpackBlock)) {
                return Direction.NORTH;
            }
            return (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)TravelersBackpackBlock.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void saveItems(CompoundNBT compound) {
        ItemStackUtils.saveAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void loadItems(CompoundNBT compound) {
        ItemStackUtils.loadAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void saveTime(CompoundNBT compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundNBT compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    @Override
    public void saveTanks(CompoundNBT compound) {
        compound.func_218657_a("LeftTank", (INBT)this.leftTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("RightTank", (INBT)this.rightTank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    public void saveSleepingBag(CompoundNBT compound) {
        compound.func_74757_a("isSleepingBagDeployed", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(CompoundNBT compound) {
        this.isSleepingBagDeployed = compound.func_74767_n("isSleepingBagDeployed");
    }

    @Override
    public void saveAllData(CompoundNBT compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveSleepingBag(compound);
        this.saveTime(compound);
    }

    @Override
    public void loadAllData(CompoundNBT compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadSleepingBag(compound);
        this.loadTime(compound);
    }

    @Override
    public CompoundNBT getTagCompound(ItemStack stack) {
        return null;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getCraftingGridInventory() {
        return this.craftingGrid;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 50, this.getUsingPlayer()) || InventoryActions.transferContainerTank(this, this.getRightTank(), 52, this.getUsingPlayer());
    }

    public PlayerEntity getUsingPlayer() {
        for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b(3.0, 3.0, 3.0))) {
            if (!(player.field_71070_bA instanceof TravelersBackpackTileContainer)) continue;
            return player;
        }
        return null;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    @Override
    public void markTankDirty() {
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean drop(World world, PlayerEntity player, BlockPos pos, Item item) {
        if (player.func_184812_l_()) {
            return true;
        }
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        this.transferToItemStack(stack);
        ItemEntity droppedItem = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        return world.func_217376_c((Entity)droppedItem);
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveTime(compound);
        stack.func_77982_d(compound);
        return stack;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_213901_a(Item itemIn) {
        int i = 0;
        for (int j = 0; j < this.func_70302_i_(); ++j) {
            ItemStack itemstack = this.func_70301_a(j);
            if (!itemstack.func_77973_b().equals(itemIn)) continue;
            i += itemstack.func_190916_E();
        }
        return i;
    }

    public boolean func_213902_a(Set<Item> set) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (!set.contains(itemstack.func_77973_b()) || itemstack.func_190916_E() <= 0) continue;
            return true;
        }
        return false;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent("TileInventoryTravelersBackpack");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("TileInventoryTravelersBackpack");
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyBlockUpdate();
    }

    private void notifyBlockUpdate() {
        BlockState blockstate = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.field_145850_b.func_217393_a(this.field_174879_c, blockstate, blockstate);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockstate, blockstate, 3);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        if (block instanceof TravelersBackpackBlock) {
            return new ItemStack((IItemProvider)block);
        }
        return new ItemStack((IItemProvider)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get());
    }

    public void openGUI(PlayerEntity player, INamedContainerProvider containerSupplier, BlockPos pos) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerSupplier, (BlockPos)pos);
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new TravelersBackpackTileContainer(id, inventory, this);
    }
}

