/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class BackpackUtils {
    public static void onPlayerDeath(World world, PlayerEntity player, ItemStack stack) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        if (((Boolean)TravelersBackpackConfig.COMMON.backpackDeathPlace.get()).booleanValue()) {
            if (!BackpackUtils.tryPlace(world, player, stack)) {
                player.func_70099_a(stack, 1.0f);
                cap.ifPresent(ITravelersBackpack::removeWearable);
                if (((Boolean)TravelersBackpackConfig.CLIENT.enableBackpackCoordsMessage.get()).booleanValue()) {
                    String translation = new TranslationTextComponent("information.travelersbackpack.backpack_drop", new Object[0]).func_150254_d();
                    player.func_145747_a((ITextComponent)new StringTextComponent(translation + " X: " + player.func_180425_c().func_177958_n() + " Y: " + player.func_180425_c().func_177956_o() + " Z: " + player.func_180425_c().func_177952_p()));
                }
            }
        } else {
            player.func_70099_a(stack, 1.0f);
            cap.ifPresent(ITravelersBackpack::removeWearable);
        }
    }

    private static boolean tryPlace(World world, PlayerEntity player, ItemStack stack) {
        int[] positions;
        int X = (int)player.field_70165_t;
        int Z = (int)player.field_70161_v;
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            BlockPos spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, X, Z, new BlockPos(X, (int)player.field_70163_u + Y, Z), 12, true, 1, (byte)0, false);
            if (spawn == null) continue;
            return BackpackUtils.placeBackpack(stack, player, world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p(), Direction.UP);
        }
        return false;
    }

    public static boolean placeBackpack(ItemStack stack, PlayerEntity player, World world, int x, int y, int z, Direction facing) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (y <= 0 || y >= world.func_217301_I()) {
            return false;
        }
        BlockPos targetPos = new BlockPos(x, y, z);
        if (world.func_180495_p(targetPos).func_185904_a().func_76222_j() && !world.func_180495_p(targetPos).func_185904_a().func_76220_a()) {
            if (!world.func_175656_a(targetPos, block.func_176223_P())) {
                return false;
            }
            if (((Boolean)TravelersBackpackConfig.CLIENT.enableBackpackCoordsMessage.get()).booleanValue()) {
                String translation = new TranslationTextComponent("information.travelersbackpack.backpack_coords", new Object[0]).func_150254_d();
                player.func_145747_a((ITextComponent)new StringTextComponent(translation + " X: " + x + " Y: " + y + " Z: " + z));
            }
            world.func_184148_a(player, (double)x, (double)y, (double)z, block.func_176223_P().func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            ((TravelersBackpackTileEntity)world.func_175625_s(targetPos)).loadAllData(stack.func_77978_p());
            if (CapabilityUtils.isWearingBackpack(player)) {
                CapabilityUtils.getCapability(player).ifPresent(cap -> cap.setWearable(ItemStack.field_190927_a));
            }
            return true;
        }
        return false;
    }

    public static BlockPos getNearestEmptyChunkCoordinatesSpiral(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.func_177958_n(); i <= pos.func_177958_n() + steps; ++i) {
                    BlockPos blockPos;
                    BlockPos blockPos2 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = pos.func_177952_p(); j >= pos.func_177952_p() - steps; --j) {
                    BlockPos blockPos;
                    BlockPos blockPos3 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.func_177958_n() - steps) {
                    BlockPos blockPos;
                    BlockPos blockPos4 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= pos.func_177952_p() + steps) {
                    BlockPos blockPos;
                    BlockPos blockPos5 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    private static BlockPos checkCoordsForBackpack(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.func_217400_a(pos.func_177972_a(Direction.DOWN), (Entity)player) && world.func_175623_d(pos) && !BackpackUtils.areCoordinatesTheSame(new BlockPos(origX, pos.func_177956_o(), origZ), pos)) {
            return pos;
        }
        if (!except && world.func_217400_a(pos.func_177972_a(Direction.DOWN), (Entity)player) && world.func_175623_d(pos)) {
            return pos;
        }
        return null;
    }

    private static BlockPos checkCoordsForPlayer(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.func_217400_a(pos.func_177972_a(Direction.DOWN), (Entity)player) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(Direction.UP)) && !BackpackUtils.areCoordinatesTheSame2D(origX, origZ, pos.func_177958_n(), pos.func_177952_p())) {
            return pos;
        }
        if (!except && world.func_217400_a(pos.func_177972_a(Direction.DOWN), (Entity)player) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(Direction.UP))) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2;
    }

    private static boolean areCoordinatesTheSame2D(int X1, int Z1, int X2, int Z2) {
        return X1 == X2 && Z1 == Z2;
    }
}

