/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tiviacz.travelersbackpack.inventory.IInventoryTravelersBackpack;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Triple;

public class RenderUtils {
    private static final double OFFSET = 0.01;
    private static final double MINY = 0.01;
    private static final double MIN = 0.135;
    private static final double MAX = 0.29;
    private static final double[][][] coordinates = new double[][][]{new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.01, 0.29}, {0.29, 0.01, 0.29}, {0.29, 0.01, 0.135}}, new double[][]{{0.135, 0.29, 0.135}, {0.135, 0.29, 0.29}, {0.29, 0.29, 0.29}, {0.29, 0.29, 0.135}}, new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.29, 0.135}, {0.29, 0.29, 0.135}, {0.29, 0.01, 0.135}}, new double[][]{{0.135, 0.01, 0.29}, {0.135, 0.29, 0.29}, {0.29, 0.29, 0.29}, {0.29, 0.01, 0.29}}, new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.29, 0.135}, {0.135, 0.29, 0.29}, {0.135, 0.01, 0.29}}, new double[][]{{0.29, 0.01, 0.135}, {0.29, 0.29, 0.135}, {0.29, 0.29, 0.29}, {0.29, 0.01, 0.29}}};

    public static void renderGuiTank(FluidTank tank, double x, double y, double height, double width) {
        RenderUtils.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, height, width);
    }

    public static void renderGuiTank(FluidStack fluid, int capacity, int amount, double x, double y, double height, double width) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getAttributes().getStillTexture().toString());
        if (icon == null) {
            icon = Minecraft.func_71410_x().func_147117_R().func_195424_a(MissingTextureSprite.func_195675_b());
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        GlStateManager.color3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GlStateManager.disableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double minV = icon.func_94206_g();
                double maxU = icon.func_94212_f();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.enableBlend();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderFluidSides(IInventoryTravelersBackpack inv, double height, FluidStack fluid) {
        Triple<Float, Float, Float> colorParts = RenderUtils.getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        for (Direction side : Direction.values()) {
            TextureAtlasSprite icon = RenderUtils.getFluidIcon(inv, fluid, side);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double[][] c = coordinates[side.ordinal()];
            double replacedMaxV = side == Direction.UP || side == Direction.DOWN ? (double)icon.func_94207_b(4.0) : (double)(icon.func_94210_h() - icon.func_94206_g()) * height + (double)icon.func_94206_g();
            double replacedU1 = side == Direction.UP || side == Direction.DOWN ? (double)icon.func_94214_a(4.0) : (double)icon.func_94214_a(7.0);
            double replacedU2 = side == Direction.UP || side == Direction.DOWN ? (double)icon.func_94214_a(8.0) : (double)icon.func_94214_a(8.0);
            worldRenderer.func_181662_b(c[0][0], RenderUtils.getHeight(c[0][1], height), c[0][2]).func_187315_a(replacedU1, replacedMaxV).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[1][0], RenderUtils.getHeight(c[1][1], height), c[1][2]).func_187315_a(replacedU1, (double)icon.func_94206_g()).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[2][0], RenderUtils.getHeight(c[2][1], height), c[2][2]).func_187315_a(replacedU2, (double)icon.func_94206_g()).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[3][0], RenderUtils.getHeight(c[3][1], height), c[3][2]).func_187315_a(replacedU2, replacedMaxV).func_181666_a(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private static double getHeight(double height, double replaceHeight) {
        if (height == 0.29) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(IInventoryTravelersBackpack inv, FluidTank tank, double x, double y, double z) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderFluidContext(tank.getFluid(), x, y, z, fluid -> {
            double height = RenderUtils.getTankFillRatio(tank) * 0.99;
            RenderUtils.renderFluidSides(inv, height, fluid);
        });
        GlStateManager.popMatrix();
    }

    public static TextureAtlasSprite getFluidIcon(IInventoryTravelersBackpack inv, FluidStack fluid, Direction side) {
        TextureAtlasSprite icon;
        Block defaultBlock;
        Block block = defaultBlock = Blocks.field_150355_j;
        if (fluid.getFluid().getAttributes().getBlock((IEnviromentBlockReader)Minecraft.func_71410_x().field_71441_e, inv.getPosition(), fluid.getFluid().func_207188_f()) != null) {
            block = fluid.getFluid().getAttributes().getBlock((IEnviromentBlockReader)Minecraft.func_71410_x().field_71441_e, inv.getPosition(), fluid.getFluid().func_207188_f()).func_177230_c();
        }
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getAttributes().getFlowing(fluid).toString())) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getAttributes().getStill(fluid).toString());
        }
        if (icon == null && (icon = RenderUtils.getBlockIcon(block)) == null) {
            icon = RenderUtils.getBlockIcon(defaultBlock);
        }
        return icon;
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static double getTankFillRatio(FluidTank tank) {
        return Math.min(1.0, (double)tank.getFluidAmount() / (double)tank.getCapacity()) * 0.5;
    }

    public static void renderFluidContext(FluidStack fluid, double x, double y, double z, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            GlStateManager.pushMatrix();
            GlStateManager.disableBlend();
            GlStateManager.disableCull();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.translated((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            render.renderFluid(fluid);
            GlStateManager.enableLighting();
            GlStateManager.enableCull();
            GlStateManager.enableBlend();
            GlStateManager.popMatrix();
        }
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
        return RenderUtils.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static interface IFluidContextRender {
        public void renderFluid(FluidStack var1);
    }
}

