/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TravelersBackpackConfig {
    public static boolean enableBackpackAbilities;
    public static boolean backpackDeathPlace;
    public static boolean toolSlotsAcceptSwords;
    public static boolean enableBackpackBlockWearable;
    public static boolean enableLoot;
    public static boolean enableEmptyTankButton;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean disableCrafting;
    public static int tanksCapacity;
    public static boolean enableBackpackCoordsMessage;
    public static boolean enableToolCycling;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            TravelersBackpackConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            TravelersBackpackConfig.bakeClientConfig();
        }
    }

    public static void bakeCommonConfig() {
        enableBackpackAbilities = (Boolean)TravelersBackpackConfig.COMMON.enableBackpackAbilities.get();
        backpackDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackDeathPlace.get();
        toolSlotsAcceptSwords = (Boolean)TravelersBackpackConfig.COMMON.toolSlotsAcceptSwords.get();
        enableBackpackBlockWearable = (Boolean)TravelersBackpackConfig.COMMON.enableBackpackBlockWearable.get();
        enableLoot = (Boolean)TravelersBackpackConfig.COMMON.enableLoot.get();
        enableEmptyTankButton = (Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get();
        enableSleepingBagSpawnPoint = (Boolean)TravelersBackpackConfig.COMMON.enableSleepingBagSpawnPoint.get();
        disableCrafting = (Boolean)TravelersBackpackConfig.COMMON.disableCrafting.get();
        tanksCapacity = (Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get();
    }

    public static void bakeClientConfig() {
        enableBackpackCoordsMessage = (Boolean)TravelersBackpackConfig.CLIENT.enableBackpackCoordsMessage.get();
        enableToolCycling = (Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get();
        obtainTips = (Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get();
        renderTools = (Boolean)TravelersBackpackConfig.CLIENT.renderTools.get();
        renderBackpackWithElytra = (Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get();
        enableOverlay = (Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get();
        offsetX = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        offsetY = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue enableBackpackCoordsMessage;
        public final ForgeConfigSpec.BooleanValue enableToolCycling;
        public final ForgeConfigSpec.BooleanValue obtainTips;
        public final ForgeConfigSpec.BooleanValue renderTools;
        public final ForgeConfigSpec.BooleanValue renderBackpackWithElytra;
        public final Overlay overlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.enableBackpackCoordsMessage = builder.comment("Enables auto message with backpack coords after player dies").translation("travelersbackpack.config.client.enableBackpackCoordsMessage").define("enableBackpackCoordsMessage", true);
            this.enableToolCycling = builder.comment("Enables tool cycling via shift + scroll combination, while backpack is worn").translation("travelersbackpack.config.client.enableToolCycling").define("enableToolCycling", true);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").translation("travelersbackpack.config.client.obtainTips").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").translation("travelersbackpack.config.client.renderTools").define("renderTools", true);
            this.renderBackpackWithElytra = builder.comment("Render backpack if elytra is present").translation("travelersbackpack.config.client.renderBackpackWithElytra").define("renderBackpackWithElytra", true);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ForgeConfigSpec.BooleanValue enableOverlay;
            public final ForgeConfigSpec.IntValue offsetX;
            public final ForgeConfigSpec.IntValue offsetY;

            Overlay(ForgeConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableBackpackAbilities;
        public final ForgeConfigSpec.BooleanValue backpackDeathPlace;
        public final ForgeConfigSpec.BooleanValue toolSlotsAcceptSwords;
        public final ForgeConfigSpec.BooleanValue enableBackpackBlockWearable;
        public final ForgeConfigSpec.BooleanValue enableLoot;
        public final ForgeConfigSpec.BooleanValue enableEmptyTankButton;
        public final ForgeConfigSpec.BooleanValue enableSleepingBagSpawnPoint;
        public final ForgeConfigSpec.BooleanValue disableCrafting;
        public final ForgeConfigSpec.IntValue tanksCapacity;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.enableBackpackAbilities = builder.translation("travelersbackpack.config.common.enableBackpackAbilities").define("enableBackpackAbilities", true);
            this.backpackDeathPlace = builder.comment("Places backpack at place where player died").translation("travelersbackpack.config.common.backpackDeathPlace").define("backpackDeathPlace", true);
            this.toolSlotsAcceptSwords = builder.translation("travelersbackpack.config.common.toolSlotsAcceptSwords").define("toolSlotsAcceptSwords", true);
            this.enableBackpackBlockWearable = builder.comment("Enables wearing backpack directly from ground").translation("travelersbackpack.config.common.enableBackpackBlockWearable").define("enableBackpackBlockWearable", true);
            this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").translation("travelersbackpack.config.common.enableLoot").define("enableLoot", true);
            this.enableEmptyTankButton = builder.comment("Enables button in backpack gui, which allows to empty tank").translation("travelersbackpack.config.common.enableEmptyTankButton").define("enableEmptyTankButton", true);
            this.enableSleepingBagSpawnPoint = builder.translation("travelersbackpack.config.common.enableSleepingBagSpawnPoint").define("enableSleepingBagSpawnPoint", false);
            this.disableCrafting = builder.translation("travelersbackpack.config.common.disableCrafting").define("disableCrafting", false);
            this.tanksCapacity = builder.translation("travelersbackpack.config.common.tanksCapacity").defineInRange("tanksCapacity", 4000, 250, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

