/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.SyncBackpackCapabilityClient;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        World world = event.getPlayer().field_70170_p;
        if (event.getNewSpawn() != null) {
            Block block = world.func_180495_p(event.getNewSpawn()).func_177230_c();
            if (!world.field_72995_K && block instanceof SleepingBagBlock && !((Boolean)TravelersBackpackConfig.COMMON.enableSleepingBagSpawnPoint.get()).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable((PlayerEntity)event.getObject());
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && CapabilityUtils.isWearingBackpack(player = (PlayerEntity)event.getEntity())) {
            if (!player.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                BackpackUtils.onPlayerDeath(player.field_70170_p, player, CapabilityUtils.getWearingBackpack(player));
            }
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        CapabilityUtils.getCapability(event.getOriginal()).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getPlayer()).ifPresent(newTravelersBackpack -> newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable())));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity && !event.getTarget().field_70170_p.field_72995_K) {
            ServerPlayerEntity target = (ServerPlayerEntity)event.getTarget();
            CapabilityUtils.getCapability((PlayerEntity)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SyncBackpackCapabilityClient(CapabilityUtils.getWearingBackpack((PlayerEntity)target).func_77955_b(new CompoundNBT()), target.func_145782_y())));
        }
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !(((ItemEntity)entity).func_92059_d().func_77973_b() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }
}

