/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.inventory.IInventoryTanks;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class InventoryActions {
    public static boolean transferContainerTank(IInventoryTanks inventory, FluidTank tank, int slotIn, @Nonnull PlayerEntity player) {
        ItemStack stackIn = inventory.func_70301_a(slotIn);
        int slotOut = slotIn + 1;
        if (tank == null || stackIn.func_190926_b() || stackIn.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        LazyOptional container = FluidUtil.getFluidHandler((ItemStack)stackIn);
        if (container.isPresent()) {
            ItemStack slotOutStack;
            ItemStack stackOut;
            FluidTank tankCopy;
            ItemStack stackInCopy;
            int amount;
            LazyOptional fluidstack = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluidstack.isPresent() && (Integer)fluidstack.map(FluidStack::getAmount).orElse((Object)0) > 0) {
                amount = (Integer)fluidstack.map(FluidStack::getAmount).orElse((Object)0);
                if (tank.getFluidAmount() + amount > tank.getCapacity()) {
                    return false;
                }
                if (tank.getFluidAmount() > 0 && !tank.getFluid().isFluidEqual((FluidStack)fluidstack.orElse((Object)FluidStack.EMPTY))) {
                    return false;
                }
                stackInCopy = stackIn.func_77946_l();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (PlayerEntity)player, (boolean)false).getResult();
                if (stackOut.func_190926_b()) {
                    return false;
                }
                slotOutStack = inventory.func_70301_a(slotOut);
                if (slotOutStack.func_190926_b() || slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                    if (slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                        stackOut.func_190920_e(slotOutStack.func_190916_E() + 1);
                        if (stackOut.func_190916_E() > slotOutStack.func_77976_d()) {
                            return false;
                        }
                    }
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (PlayerEntity)player, (boolean)true);
                    inventory.func_70299_a(slotOut, stackOut);
                    inventory.func_70298_a(slotIn, 1);
                    inventory.markTankDirty();
                    return true;
                }
            }
            if (tank.isEmpty() || tank.getFluidAmount() <= 0) {
                return false;
            }
            if (InventoryActions.isFluidEqual(stackIn, tank)) {
                amount = (Integer)FluidUtil.getFluidHandler((ItemStack)stackIn).map(iFluidHandlerItem -> iFluidHandlerItem.getTankCapacity(0)).orElse((Object)0);
                stackInCopy = stackIn.func_77946_l();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryFillContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (PlayerEntity)player, (boolean)true).getResult();
                if (stackOut.func_190926_b()) {
                    return false;
                }
                slotOutStack = inventory.func_70301_a(slotOut);
                if (slotOutStack.func_190926_b() || slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                    if (slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                        stackOut.func_190920_e(slotOutStack.func_190916_E() + 1);
                        if (stackOut.func_190916_E() > slotOutStack.func_77976_d()) {
                            return false;
                        }
                    }
                    FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (PlayerEntity)player, (boolean)true);
                    inventory.func_70299_a(slotOut, stackOut);
                    inventory.func_70298_a(slotIn, 1);
                    inventory.markTankDirty();
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn).isPresent() && (Integer)FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::getAmount).orElse((Object)0) > 0) {
            return (Boolean)FluidUtil.getFluidContained((ItemStack)stackIn).map(fluidstack -> fluidstack.isFluidEqual(tank.getFluid())).orElse((Object)false);
        }
        return (Boolean)FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::isEmpty).orElse((Object)false);
    }
}

