/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.container.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.container.slot.FluidSlot;
import com.tiviacz.travelersbackpack.inventory.container.slot.ToolSlot;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class TravelersBackpackBaseContainer
extends Container {
    public PlayerInventory playerInventory;
    public IInventoryTravelersBackpack inventory;
    public CraftingInventoryImproved craftMatrix;
    public CraftResultInventory craftResult = new CraftResultInventory();
    public World world;
    private final int BACKPACK_INV_START = 10;
    private final int BACKPACK_INV_END = 48;
    private final int TOOL_START = 49;
    private final int TOOL_END = 50;
    private final int BUCKET_LEFT_IN = 51;
    private final int BUCKET_LEFT_OUT = 52;
    private final int BUCKET_RIGHT_IN = 53;
    private final int BUCKET_RIGHT_OUT = 54;
    private final int PLAYER_INV_START = 55;
    private final int PLAYER_HOT_END = 90;

    public TravelersBackpackBaseContainer(ContainerType<?> type, int windowID, PlayerInventory playerInventory, IInventoryTravelersBackpack inventory) {
        super(type, windowID);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this, 3, 3);
        int currentItemIndex = playerInventory.field_70461_c;
        this.addCraftResult(playerInventory.field_70458_d);
        this.addCraftMatrix();
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInventory, currentItemIndex);
        this.func_75130_a(inventory);
    }

    public void addCraftMatrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new BackpackSlot((IInventory)this.craftMatrix, j + i * 3, 152 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addCraftResult(PlayerEntity player) {
        this.func_75146_a((Slot)new CraftingResultSlot(player, (CraftingInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 226, 97));
    }

    public void addBackpackInventory(IInventoryTravelersBackpack inventory) {
        int j;
        int i;
        int slot = 9;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                this.func_75146_a(new BackpackSlot(inventory, slot++, 62 + j * 18, 7 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.func_75146_a(new BackpackSlot(inventory, slot++, 62 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(PlayerInventory playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 44 + x * 18, 125 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 44 + x * 18, 183));
        }
    }

    public void addFluidSlots(IInventoryTravelersBackpack inventory) {
        this.func_75146_a(new FluidSlot(inventory, 50, 6, 7));
        this.func_75146_a(new FluidSlot(inventory, 51, 6, 37));
        this.func_75146_a(new FluidSlot(inventory, 52, 226, 7));
        this.func_75146_a(new FluidSlot(inventory, 53, 226, 37));
    }

    public void addToolSlots(IInventoryTravelersBackpack inventory) {
        this.func_75146_a(new ToolSlot(this.playerInventory.field_70458_d, inventory, 48, 44, 79));
        this.func_75146_a(new ToolSlot(this.playerInventory.field_70458_d, inventory, 49, 44, 97));
    }

    public void func_75130_a(IInventory inventory) {
        if (!((Boolean)TravelersBackpackConfig.COMMON.disableCrafting.get()).booleanValue()) {
            CraftingInventoryImproved craftMatrix = this.craftMatrix;
            CraftResultInventory craftResult = this.craftResult;
            World world = this.playerInventory.field_70458_d.field_70170_p;
            if (!world.field_72995_K) {
                ICraftingRecipe icraftingrecipe;
                ServerPlayerEntity player = (ServerPlayerEntity)this.playerInventory.field_70458_d;
                ItemStack itemstack = ItemStack.field_190927_a;
                Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftMatrix, world);
                if (optional.isPresent() && craftResult.func_201561_a(world, player, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                    itemstack = icraftingrecipe.func_77572_b((IInventory)craftMatrix);
                }
                craftResult.func_70299_a(0, itemstack);
                player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, itemstack));
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack result = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (index >= 0 && index <= 54) {
                if (index == 0) {
                    stack.func_77973_b().func_77622_d(stack, this.world, player);
                    if (!this.func_75135_a(stack, 55, 91, true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack, result);
                    this.craftMatrix.func_70296_d();
                } else if (!this.func_75135_a(stack, 55, 91, true)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (index >= 55) {
                if (ToolSlot.isValid(stack) && !this.func_75135_a(stack, 49, 51, false) && !this.func_75135_a(stack, 10, 49, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, 10, 49, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return result;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!(this.inventory.func_70301_a(50).func_190926_b() && this.inventory.func_70301_a(51).func_190926_b() && this.inventory.func_70301_a(52).func_190926_b() && this.inventory.func_70301_a(53).func_190926_b())) {
            this.world.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        this.clearBucketSlot(playerIn, this.world, this.inventory, 50);
        this.clearBucketSlot(playerIn, this.world, this.inventory, 52);
        this.clearBucketSlot(playerIn, this.world, this.inventory, 51);
        this.clearBucketSlot(playerIn, this.world, this.inventory, 53);
    }

    private void clearBucketSlot(PlayerEntity playerIn, World worldIn, IInventoryTravelersBackpack inventoryIn, int index) {
        if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
            playerIn.func_71019_a(inventoryIn.func_70304_b(index), false);
        } else {
            playerIn.field_71071_by.func_191975_a(worldIn, inventoryIn.func_70304_b(index));
        }
    }
}

