/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HoseItem
extends Item {
    public HoseItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("travelersbackpack", "mode"), (stack, world, entity) -> {
            CompoundNBT compound = stack.func_77978_p();
            if (compound == null) {
                return 0.0f;
            }
            return compound.func_74762_e("Mode");
        });
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (HoseItem.getHoseMode(stack) == 3) {
            return UseAction.DRINK;
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 24;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        ItemStack stack = player.func_184614_ca();
        if (CapabilityUtils.isWearingBackpack(player)) {
            FluidStack fluidStack;
            if (stack.func_77978_p() == null) {
                this.getCompoundTag(stack);
                return ActionResultType.PASS;
            }
            LazyOptional fluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)direction);
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (HoseItem.getHoseMode(stack) == 1) {
                if (fluidHandler.isPresent()) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (int)1000, (boolean)true);
                    inv.markTankDirty();
                    world.func_184133_a(player, pos, (SoundEvent)fluidHandler.map(f -> f.getFluidInTank(0).getFluid().getAttributes().getFillSound()).orElse((Object)SoundEvents.field_187630_M), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
                RayTraceResult result = HoseItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos fluidPos = new BlockPos(result.func_216347_e().func_82615_a(), result.func_216347_e().func_82617_b(), result.func_216347_e().func_82616_c());
                    BlockState fluidState = world.func_180495_p(fluidPos);
                    if (fluidState.func_177230_c() instanceof IFluidBlock) {
                        IFluidHandler targetFluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)fluidPos, (Direction)direction).orElse(null);
                        if (targetFluidHandler != null) {
                            FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)targetFluidHandler, (int)1000, (boolean)true);
                            world.func_184133_a(player, fluidPos, targetFluidHandler.getFluidInTank(0).getFluid().getAttributes().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            inv.markTankDirty();
                            return ActionResultType.SUCCESS;
                        }
                    } else if (fluidState.func_177230_c() instanceof FlowingFluidBlock) {
                        boolean canFill;
                        FlowingFluid fluid = ((FlowingFluidBlock)fluidState.func_177230_c()).getFluid();
                        fluidStack = new FluidStack((Fluid)fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || tank.getFluid().isFluidEqual(fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity()) {
                            world.func_184133_a(player, fluidPos, fluid.getAttributes().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            world.func_175656_a(fluidPos, Blocks.field_150350_a.func_176223_P());
                            world.func_195592_c(fluidPos, fluidState.func_177230_c());
                            inv.markTankDirty();
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2) {
                if (fluidHandler.isPresent()) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (IFluidHandler)tank, (int)1000, (boolean)true);
                    inv.markTankDirty();
                    return ActionResultType.SUCCESS;
                }
                if (!tank.isEmpty()) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    if (!world.func_180495_p(pos).func_227032_a_(tank.getFluid().getFluid())) {
                        switch (context.func_196000_l()) {
                            case WEST: {
                                --x;
                                break;
                            }
                            case EAST: {
                                ++x;
                                break;
                            }
                            case NORTH: {
                                --z;
                                break;
                            }
                            case SOUTH: {
                                ++z;
                                break;
                            }
                            case UP: {
                                ++y;
                                break;
                            }
                            case DOWN: {
                                --y;
                                break;
                            }
                        }
                    }
                    BlockPos newPos = new BlockPos(x, y, z);
                    fluidStack = tank.getFluid();
                    if (fluidStack.getFluid().getAttributes().canBePlacedInWorld((ILightReader)world, newPos, fluidStack)) {
                        boolean flag;
                        Material material = world.func_180495_p(newPos).func_185904_a();
                        boolean bl = flag = !material.func_76220_a();
                        if (world.field_73011_w.func_177500_n() && fluidStack.getFluid() instanceof WaterFluid) {
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            inv.markTankDirty();
                            world.func_184133_a(null, newPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                            int i = 0;
                            if (i < 3) {
                                double d0 = (double)newPos.func_177958_n() + world.field_73012_v.nextDouble();
                                double d1 = (double)newPos.func_177956_o() + world.field_73012_v.nextDouble() * 0.5 + 0.5;
                                double d2 = (double)newPos.func_177952_p() + world.field_73012_v.nextDouble();
                                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
                                return ActionResultType.SUCCESS;
                            }
                        }
                        if (fluidStack.getAmount() >= 1000) {
                            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                                world.func_175655_b(newPos, false);
                            }
                            if (world.func_175656_a(newPos, fluidStack.getFluid().func_207188_f().func_206883_i())) {
                                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                                world.func_195592_c(newPos, fluidStack.getFluid().func_207188_f().func_206883_i().func_177230_c());
                            }
                            world.func_184133_a(player, newPos, fluidStack.getFluid().getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            inv.markTankDirty();
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasFluidEffectAndCanExecute(tank.getFluid(), world, (Entity)player)) {
                player.func_184598_c(Hand.MAIN_HAND);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity player;
        if (entityLiving instanceof PlayerEntity && CapabilityUtils.isWearingBackpack(player = (PlayerEntity)entityLiving)) {
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (HoseItem.getHoseMode(stack) == 3 && tank != null && ServerActions.setFluidEffect(worldIn, player, tank)) {
                EffectFluid targetEffect = EffectFluidRegistry.getFluidEffect(tank.getFluid().getFluid());
                tank.drain(targetEffect.amountRequired, IFluidHandler.FluidAction.EXECUTE);
                inv.markTankDirty();
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184614_ca();
        if (CapabilityUtils.isWearingBackpack(playerIn)) {
            if (stack.func_77978_p() == null) {
                this.getCompoundTag(stack);
                return ActionResult.func_226250_c_((Object)stack);
            }
            FluidTank tank = this.getSelectedFluidTank(stack, CapabilityUtils.getBackpackInv(playerIn));
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && tank.getFluidAmount() >= 1000 && EffectFluidRegistry.hasFluidEffect(tank.getFluid().getFluid())) {
                playerIn.func_184598_c(Hand.MAIN_HAND);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public static int getHoseMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Mode");
        }
        return 0;
    }

    public static int getHoseTank(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Tank");
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(ItemStack stack, TravelersBackpackInventory inv) {
        return HoseItem.getHoseTank(stack) == 1 ? inv.getLeftTank() : inv.getRightTank();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && !CapabilityUtils.isWearingBackpack((PlayerEntity)entityIn) && stack.func_77978_p() != null) {
            stack.func_77982_d(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (HoseItem.getHoseMode(stack) == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("hose.not_assigned", new Object[0]));
        } else if (stack.func_77978_p() != null) {
            CompoundNBT compound = stack.func_77978_p();
            if (compound.func_74762_e("Mode") == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.current_mode_suck", new Object[0]));
            }
            if (compound.func_74762_e("Mode") == 2) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.current_mode_spill", new Object[0]));
            }
            if (compound.func_74762_e("Mode") == 3) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.current_mode_drink", new Object[0]));
            }
            if (compound.func_74762_e("Tank") == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.current_tank_left", new Object[0]));
            }
            if (compound.func_74762_e("Tank") == 2) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.current_tank_right", new Object[0]));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        int x = HoseItem.getHoseMode(stack);
        String mode = "";
        String localizedName = new TranslationTextComponent("item.travelersbackpack.hose.name", new Object[0]).func_150254_d();
        String suckMode = new TranslationTextComponent("item.travelersbackpack.hose.suck", new Object[0]).func_150254_d();
        String spillMode = new TranslationTextComponent("item.travelersbackpack.hose.spill", new Object[0]).func_150254_d();
        String drinkMode = new TranslationTextComponent("item.travelersbackpack.hose.drink", new Object[0]).func_150254_d();
        if (x == 1) {
            mode = " " + suckMode;
        } else if (x == 2) {
            mode = " " + spillMode;
        } else if (x == 3) {
            mode = " " + drinkMode;
        }
        return new StringTextComponent(localizedName + mode);
    }

    public CompoundNBT getCompoundTag(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!(tag = stack.func_77978_p()).func_186855_b("Tank")) {
            tag.func_74768_a("Tank", 1);
        }
        if (!tag.func_186855_b("Mode")) {
            tag.func_74768_a("Mode", 1);
        }
        return tag;
    }
}

